/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListScanJobSummariesResponse extends BackupResponse implements
        ToCopyableBuilder<ListScanJobSummariesResponse.Builder, ListScanJobSummariesResponse> {
    private static final SdkField<List<ScanJobSummary>> SCAN_JOB_SUMMARIES_FIELD = SdkField
            .<List<ScanJobSummary>> builder(MarshallingType.LIST)
            .memberName("ScanJobSummaries")
            .getter(getter(ListScanJobSummariesResponse::scanJobSummaries))
            .setter(setter(Builder::scanJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScanJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScanJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AGGREGATION_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AggregationPeriod").getter(getter(ListScanJobSummariesResponse::aggregationPeriod))
            .setter(setter(Builder::aggregationPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationPeriod").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListScanJobSummariesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_JOB_SUMMARIES_FIELD,
            AGGREGATION_PERIOD_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ScanJobSummary> scanJobSummaries;

    private final String aggregationPeriod;

    private final String nextToken;

    private ListScanJobSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.scanJobSummaries = builder.scanJobSummaries;
        this.aggregationPeriod = builder.aggregationPeriod;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanJobSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScanJobSummaries() {
        return scanJobSummaries != null && !(scanJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summary information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanJobSummaries} method.
     * </p>
     * 
     * @return The summary information.
     */
    public final List<ScanJobSummary> scanJobSummaries() {
        return scanJobSummaries;
    }

    /**
     * <p>
     * The period for the returned results.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ONE_DAY</code>The daily job count for the prior 1 day.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SEVEN_DAYS</code>The daily job count for the prior 7 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FOURTEEN_DAYS</code>The daily job count for the prior 14 days.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Valid Values: <code>'ONE_DAY'</code> | <code>'SEVEN_DAYS'</code> | <code>'FOURTEEN_DAYS'</code>
     * </p>
     * 
     * @return The period for the returned results.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ONE_DAY</code>The daily job count for the prior 1 day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SEVEN_DAYS</code>The daily job count for the prior 7 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FOURTEEN_DAYS</code>The daily job count for the prior 14 days.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Valid Values: <code>'ONE_DAY'</code> | <code>'SEVEN_DAYS'</code> | <code>'FOURTEEN_DAYS'</code>
     */
    public final String aggregationPeriod() {
        return aggregationPeriod;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request is made to return
     * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request is made to return
     *         <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasScanJobSummaries() ? scanJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(aggregationPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScanJobSummariesResponse)) {
            return false;
        }
        ListScanJobSummariesResponse other = (ListScanJobSummariesResponse) obj;
        return hasScanJobSummaries() == other.hasScanJobSummaries()
                && Objects.equals(scanJobSummaries(), other.scanJobSummaries())
                && Objects.equals(aggregationPeriod(), other.aggregationPeriod())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListScanJobSummariesResponse")
                .add("ScanJobSummaries", hasScanJobSummaries() ? scanJobSummaries() : null)
                .add("AggregationPeriod", aggregationPeriod()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScanJobSummaries":
            return Optional.ofNullable(clazz.cast(scanJobSummaries()));
        case "AggregationPeriod":
            return Optional.ofNullable(clazz.cast(aggregationPeriod()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScanJobSummaries", SCAN_JOB_SUMMARIES_FIELD);
        map.put("AggregationPeriod", AGGREGATION_PERIOD_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListScanJobSummariesResponse, T> g) {
        return obj -> g.apply((ListScanJobSummariesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListScanJobSummariesResponse> {
        /**
         * <p>
         * The summary information.
         * </p>
         * 
         * @param scanJobSummaries
         *        The summary information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanJobSummaries(Collection<ScanJobSummary> scanJobSummaries);

        /**
         * <p>
         * The summary information.
         * </p>
         * 
         * @param scanJobSummaries
         *        The summary information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanJobSummaries(ScanJobSummary... scanJobSummaries);

        /**
         * <p>
         * The summary information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.ScanJobSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.backup.model.ScanJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.ScanJobSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #scanJobSummaries(List<ScanJobSummary>)}.
         * 
         * @param scanJobSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.ScanJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanJobSummaries(java.util.Collection<ScanJobSummary>)
         */
        Builder scanJobSummaries(Consumer<ScanJobSummary.Builder>... scanJobSummaries);

        /**
         * <p>
         * The period for the returned results.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ONE_DAY</code>The daily job count for the prior 1 day.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SEVEN_DAYS</code>The daily job count for the prior 7 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FOURTEEN_DAYS</code>The daily job count for the prior 14 days.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Valid Values: <code>'ONE_DAY'</code> | <code>'SEVEN_DAYS'</code> | <code>'FOURTEEN_DAYS'</code>
         * </p>
         * 
         * @param aggregationPeriod
         *        The period for the returned results.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ONE_DAY</code>The daily job count for the prior 1 day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SEVEN_DAYS</code>The daily job count for the prior 7 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FOURTEEN_DAYS</code>The daily job count for the prior 14 days.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Valid Values: <code>'ONE_DAY'</code> | <code>'SEVEN_DAYS'</code> | <code>'FOURTEEN_DAYS'</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationPeriod(String aggregationPeriod);

        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request is made to return
         * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request is made to return
         *        <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private List<ScanJobSummary> scanJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String aggregationPeriod;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListScanJobSummariesResponse model) {
            super(model);
            scanJobSummaries(model.scanJobSummaries);
            aggregationPeriod(model.aggregationPeriod);
            nextToken(model.nextToken);
        }

        public final List<ScanJobSummary.Builder> getScanJobSummaries() {
            List<ScanJobSummary.Builder> result = ScanJobSummaryListCopier.copyToBuilder(this.scanJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanJobSummaries(Collection<ScanJobSummary.BuilderImpl> scanJobSummaries) {
            this.scanJobSummaries = ScanJobSummaryListCopier.copyFromBuilder(scanJobSummaries);
        }

        @Override
        public final Builder scanJobSummaries(Collection<ScanJobSummary> scanJobSummaries) {
            this.scanJobSummaries = ScanJobSummaryListCopier.copy(scanJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanJobSummaries(ScanJobSummary... scanJobSummaries) {
            scanJobSummaries(Arrays.asList(scanJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanJobSummaries(Consumer<ScanJobSummary.Builder>... scanJobSummaries) {
            scanJobSummaries(Stream.of(scanJobSummaries).map(c -> ScanJobSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAggregationPeriod() {
            return aggregationPeriod;
        }

        public final void setAggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
        }

        @Override
        public final Builder aggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListScanJobSummariesResponse build() {
            return new ListScanJobSummariesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
