/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateBackupVaultMpaApprovalTeamRequest extends BackupRequest implements
        ToCopyableBuilder<AssociateBackupVaultMpaApprovalTeamRequest.Builder, AssociateBackupVaultMpaApprovalTeamRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(AssociateBackupVaultMpaApprovalTeamRequest::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupVaultName").build()).build();

    private static final SdkField<String> MPA_APPROVAL_TEAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MpaApprovalTeamArn").getter(getter(AssociateBackupVaultMpaApprovalTeamRequest::mpaApprovalTeamArn))
            .setter(setter(Builder::mpaApprovalTeamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MpaApprovalTeamArn").build())
            .build();

    private static final SdkField<String> REQUESTER_COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequesterComment").getter(getter(AssociateBackupVaultMpaApprovalTeamRequest::requesterComment))
            .setter(setter(Builder::requesterComment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterComment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD,
            MPA_APPROVAL_TEAM_ARN_FIELD, REQUESTER_COMMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String backupVaultName;

    private final String mpaApprovalTeamArn;

    private final String requesterComment;

    private AssociateBackupVaultMpaApprovalTeamRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.mpaApprovalTeamArn = builder.mpaApprovalTeamArn;
        this.requesterComment = builder.requesterComment;
    }

    /**
     * <p>
     * The name of the backup vault to associate with the MPA approval team.
     * </p>
     * 
     * @return The name of the backup vault to associate with the MPA approval team.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the MPA approval team to associate with the backup vault.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the MPA approval team to associate with the backup vault.
     */
    public final String mpaApprovalTeamArn() {
        return mpaApprovalTeamArn;
    }

    /**
     * <p>
     * A comment provided by the requester explaining the association request.
     * </p>
     * 
     * @return A comment provided by the requester explaining the association request.
     */
    public final String requesterComment() {
        return requesterComment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(mpaApprovalTeamArn());
        hashCode = 31 * hashCode + Objects.hashCode(requesterComment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateBackupVaultMpaApprovalTeamRequest)) {
            return false;
        }
        AssociateBackupVaultMpaApprovalTeamRequest other = (AssociateBackupVaultMpaApprovalTeamRequest) obj;
        return Objects.equals(backupVaultName(), other.backupVaultName())
                && Objects.equals(mpaApprovalTeamArn(), other.mpaApprovalTeamArn())
                && Objects.equals(requesterComment(), other.requesterComment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateBackupVaultMpaApprovalTeamRequest").add("BackupVaultName", backupVaultName())
                .add("MpaApprovalTeamArn", mpaApprovalTeamArn())
                .add("RequesterComment", requesterComment() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "MpaApprovalTeamArn":
            return Optional.ofNullable(clazz.cast(mpaApprovalTeamArn()));
        case "RequesterComment":
            return Optional.ofNullable(clazz.cast(requesterComment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("backupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("MpaApprovalTeamArn", MPA_APPROVAL_TEAM_ARN_FIELD);
        map.put("RequesterComment", REQUESTER_COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateBackupVaultMpaApprovalTeamRequest, T> g) {
        return obj -> g.apply((AssociateBackupVaultMpaApprovalTeamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateBackupVaultMpaApprovalTeamRequest> {
        /**
         * <p>
         * The name of the backup vault to associate with the MPA approval team.
         * </p>
         * 
         * @param backupVaultName
         *        The name of the backup vault to associate with the MPA approval team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the MPA approval team to associate with the backup vault.
         * </p>
         * 
         * @param mpaApprovalTeamArn
         *        The Amazon Resource Name (ARN) of the MPA approval team to associate with the backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mpaApprovalTeamArn(String mpaApprovalTeamArn);

        /**
         * <p>
         * A comment provided by the requester explaining the association request.
         * </p>
         * 
         * @param requesterComment
         *        A comment provided by the requester explaining the association request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterComment(String requesterComment);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String backupVaultName;

        private String mpaApprovalTeamArn;

        private String requesterComment;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateBackupVaultMpaApprovalTeamRequest model) {
            super(model);
            backupVaultName(model.backupVaultName);
            mpaApprovalTeamArn(model.mpaApprovalTeamArn);
            requesterComment(model.requesterComment);
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getMpaApprovalTeamArn() {
            return mpaApprovalTeamArn;
        }

        public final void setMpaApprovalTeamArn(String mpaApprovalTeamArn) {
            this.mpaApprovalTeamArn = mpaApprovalTeamArn;
        }

        @Override
        public final Builder mpaApprovalTeamArn(String mpaApprovalTeamArn) {
            this.mpaApprovalTeamArn = mpaApprovalTeamArn;
            return this;
        }

        public final String getRequesterComment() {
            return requesterComment;
        }

        public final void setRequesterComment(String requesterComment) {
            this.requesterComment = requesterComment;
        }

        @Override
        public final Builder requesterComment(String requesterComment) {
            this.requesterComment = requesterComment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateBackupVaultMpaApprovalTeamRequest build() {
            return new AssociateBackupVaultMpaApprovalTeamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
