/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse;

public class ListRecoveryPointsByBackupVaultIterable
implements SdkIterable<ListRecoveryPointsByBackupVaultResponse> {
    private final BackupClient client;
    private final ListRecoveryPointsByBackupVaultRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecoveryPointsByBackupVaultIterable(BackupClient client, ListRecoveryPointsByBackupVaultRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRecoveryPointsByBackupVaultResponseFetcher();
    }

    public Iterator<ListRecoveryPointsByBackupVaultResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListRecoveryPointsByBackupVaultIterable resume(ListRecoveryPointsByBackupVaultResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListRecoveryPointsByBackupVaultIterable(this.client, (ListRecoveryPointsByBackupVaultRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListRecoveryPointsByBackupVaultIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListRecoveryPointsByBackupVaultResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListRecoveryPointsByBackupVaultResponseFetcher
    implements SyncPageFetcher<ListRecoveryPointsByBackupVaultResponse> {
        private ListRecoveryPointsByBackupVaultResponseFetcher() {
        }

        public boolean hasNextPage(ListRecoveryPointsByBackupVaultResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecoveryPointsByBackupVaultResponse nextPage(ListRecoveryPointsByBackupVaultResponse previousPage) {
            if (previousPage == null) {
                return ListRecoveryPointsByBackupVaultIterable.this.client.listRecoveryPointsByBackupVault(ListRecoveryPointsByBackupVaultIterable.this.firstRequest);
            }
            return ListRecoveryPointsByBackupVaultIterable.this.client.listRecoveryPointsByBackupVault((ListRecoveryPointsByBackupVaultRequest)((Object)ListRecoveryPointsByBackupVaultIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

