/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RuleExecutionType {
    CONTINUOUS("CONTINUOUS"),
    SNAPSHOTS("SNAPSHOTS"),
    CONTINUOUS_AND_SNAPSHOTS("CONTINUOUS_AND_SNAPSHOTS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RuleExecutionType> VALUE_MAP;
    private final String value;

    private RuleExecutionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RuleExecutionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RuleExecutionType> knownValues() {
        EnumSet<RuleExecutionType> knownValues = EnumSet.allOf(RuleExecutionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RuleExecutionType.class, RuleExecutionType::toString);
    }
}

