/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLogicallyAirGappedBackupVaultRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, CreateLogicallyAirGappedBackupVaultRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(CreateLogicallyAirGappedBackupVaultRequest.getter(CreateLogicallyAirGappedBackupVaultRequest::backupVaultName)).setter(CreateLogicallyAirGappedBackupVaultRequest.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupVaultName").build()}).build();
    private static final SdkField<Map<String, String>> BACKUP_VAULT_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("BackupVaultTags").getter(CreateLogicallyAirGappedBackupVaultRequest.getter(CreateLogicallyAirGappedBackupVaultRequest::backupVaultTags)).setter(CreateLogicallyAirGappedBackupVaultRequest.setter(Builder::backupVaultTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(CreateLogicallyAirGappedBackupVaultRequest.getter(CreateLogicallyAirGappedBackupVaultRequest::creatorRequestId)).setter(CreateLogicallyAirGappedBackupVaultRequest.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Long> MIN_RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MinRetentionDays").getter(CreateLogicallyAirGappedBackupVaultRequest.getter(CreateLogicallyAirGappedBackupVaultRequest::minRetentionDays)).setter(CreateLogicallyAirGappedBackupVaultRequest.setter(Builder::minRetentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinRetentionDays").build()}).build();
    private static final SdkField<Long> MAX_RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxRetentionDays").getter(CreateLogicallyAirGappedBackupVaultRequest.getter(CreateLogicallyAirGappedBackupVaultRequest::maxRetentionDays)).setter(CreateLogicallyAirGappedBackupVaultRequest.setter(Builder::maxRetentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetentionDays").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD, BACKUP_VAULT_TAGS_FIELD, CREATOR_REQUEST_ID_FIELD, MIN_RETENTION_DAYS_FIELD, MAX_RETENTION_DAYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLogicallyAirGappedBackupVaultRequest.memberNameToFieldInitializer();
    private final String backupVaultName;
    private final Map<String, String> backupVaultTags;
    private final String creatorRequestId;
    private final Long minRetentionDays;
    private final Long maxRetentionDays;

    private CreateLogicallyAirGappedBackupVaultRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.backupVaultTags = builder.backupVaultTags;
        this.creatorRequestId = builder.creatorRequestId;
        this.minRetentionDays = builder.minRetentionDays;
        this.maxRetentionDays = builder.maxRetentionDays;
    }

    public final String backupVaultName() {
        return this.backupVaultName;
    }

    public final boolean hasBackupVaultTags() {
        return this.backupVaultTags != null && !(this.backupVaultTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> backupVaultTags() {
        return this.backupVaultTags;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final Long minRetentionDays() {
        return this.minRetentionDays;
    }

    public final Long maxRetentionDays() {
        return this.maxRetentionDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackupVaultTags() ? this.backupVaultTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.minRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetentionDays());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLogicallyAirGappedBackupVaultRequest)) {
            return false;
        }
        CreateLogicallyAirGappedBackupVaultRequest other = (CreateLogicallyAirGappedBackupVaultRequest)((Object)obj);
        return Objects.equals(this.backupVaultName(), other.backupVaultName()) && this.hasBackupVaultTags() == other.hasBackupVaultTags() && Objects.equals(this.backupVaultTags(), other.backupVaultTags()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.minRetentionDays(), other.minRetentionDays()) && Objects.equals(this.maxRetentionDays(), other.maxRetentionDays());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLogicallyAirGappedBackupVaultRequest").add("BackupVaultName", (Object)this.backupVaultName()).add("BackupVaultTags", (Object)(this.backupVaultTags() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatorRequestId", (Object)this.creatorRequestId()).add("MinRetentionDays", (Object)this.minRetentionDays()).add("MaxRetentionDays", (Object)this.maxRetentionDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "BackupVaultTags": {
                return Optional.ofNullable(clazz.cast(this.backupVaultTags()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "MinRetentionDays": {
                return Optional.ofNullable(clazz.cast(this.minRetentionDays()));
            }
            case "MaxRetentionDays": {
                return Optional.ofNullable(clazz.cast(this.maxRetentionDays()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("backupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("BackupVaultTags", BACKUP_VAULT_TAGS_FIELD);
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        map.put("MinRetentionDays", MIN_RETENTION_DAYS_FIELD);
        map.put("MaxRetentionDays", MAX_RETENTION_DAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLogicallyAirGappedBackupVaultRequest, T> g) {
        return obj -> g.apply((CreateLogicallyAirGappedBackupVaultRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String backupVaultName;
        private Map<String, String> backupVaultTags = DefaultSdkAutoConstructMap.getInstance();
        private String creatorRequestId;
        private Long minRetentionDays;
        private Long maxRetentionDays;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLogicallyAirGappedBackupVaultRequest model) {
            super(model);
            this.backupVaultName(model.backupVaultName);
            this.backupVaultTags(model.backupVaultTags);
            this.creatorRequestId(model.creatorRequestId);
            this.minRetentionDays(model.minRetentionDays);
            this.maxRetentionDays(model.maxRetentionDays);
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final Map<String, String> getBackupVaultTags() {
            if (this.backupVaultTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.backupVaultTags;
        }

        public final void setBackupVaultTags(Map<String, String> backupVaultTags) {
            this.backupVaultTags = TagsCopier.copy(backupVaultTags);
        }

        @Override
        public final Builder backupVaultTags(Map<String, String> backupVaultTags) {
            this.backupVaultTags = TagsCopier.copy(backupVaultTags);
            return this;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final Long getMinRetentionDays() {
            return this.minRetentionDays;
        }

        public final void setMinRetentionDays(Long minRetentionDays) {
            this.minRetentionDays = minRetentionDays;
        }

        @Override
        public final Builder minRetentionDays(Long minRetentionDays) {
            this.minRetentionDays = minRetentionDays;
            return this;
        }

        public final Long getMaxRetentionDays() {
            return this.maxRetentionDays;
        }

        public final void setMaxRetentionDays(Long maxRetentionDays) {
            this.maxRetentionDays = maxRetentionDays;
        }

        @Override
        public final Builder maxRetentionDays(Long maxRetentionDays) {
            this.maxRetentionDays = maxRetentionDays;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLogicallyAirGappedBackupVaultRequest build() {
            return new CreateLogicallyAirGappedBackupVaultRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLogicallyAirGappedBackupVaultRequest> {
        public Builder backupVaultName(String var1);

        public Builder backupVaultTags(Map<String, String> var1);

        public Builder creatorRequestId(String var1);

        public Builder minRetentionDays(Long var1);

        public Builder maxRetentionDays(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

