/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.CopyJobChildJobsInStateCopier;
import software.amazon.awssdk.services.backup.model.CopyJobState;
import software.amazon.awssdk.services.backup.model.RecoveryPointCreator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CopyJob> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(CopyJob.getter(CopyJob::accountId)).setter(CopyJob.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> COPY_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CopyJobId").getter(CopyJob.getter(CopyJob::copyJobId)).setter(CopyJob.setter(Builder::copyJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyJobId").build()}).build();
    private static final SdkField<String> SOURCE_BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceBackupVaultArn").getter(CopyJob.getter(CopyJob::sourceBackupVaultArn)).setter(CopyJob.setter(Builder::sourceBackupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBackupVaultArn").build()}).build();
    private static final SdkField<String> SOURCE_RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceRecoveryPointArn").getter(CopyJob.getter(CopyJob::sourceRecoveryPointArn)).setter(CopyJob.setter(Builder::sourceRecoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRecoveryPointArn").build()}).build();
    private static final SdkField<String> DESTINATION_BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationBackupVaultArn").getter(CopyJob.getter(CopyJob::destinationBackupVaultArn)).setter(CopyJob.setter(Builder::destinationBackupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationBackupVaultArn").build()}).build();
    private static final SdkField<String> DESTINATION_RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationRecoveryPointArn").getter(CopyJob.getter(CopyJob::destinationRecoveryPointArn)).setter(CopyJob.setter(Builder::destinationRecoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationRecoveryPointArn").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(CopyJob.getter(CopyJob::resourceArn)).setter(CopyJob.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(CopyJob.getter(CopyJob::creationDate)).setter(CopyJob.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> COMPLETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionDate").getter(CopyJob.getter(CopyJob::completionDate)).setter(CopyJob.setter(Builder::completionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CopyJob.getter(CopyJob::stateAsString)).setter(CopyJob.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(CopyJob.getter(CopyJob::statusMessage)).setter(CopyJob.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Long> BACKUP_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BackupSizeInBytes").getter(CopyJob.getter(CopyJob::backupSizeInBytes)).setter(CopyJob.setter(Builder::backupSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeInBytes").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(CopyJob.getter(CopyJob::iamRoleArn)).setter(CopyJob.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<RecoveryPointCreator> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(CopyJob.getter(CopyJob::createdBy)).setter(CopyJob.setter(Builder::createdBy)).constructor(RecoveryPointCreator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(CopyJob.getter(CopyJob::resourceType)).setter(CopyJob.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> PARENT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentJobId").getter(CopyJob.getter(CopyJob::parentJobId)).setter(CopyJob.setter(Builder::parentJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentJobId").build()}).build();
    private static final SdkField<Boolean> IS_PARENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsParent").getter(CopyJob.getter(CopyJob::isParent)).setter(CopyJob.setter(Builder::isParent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsParent").build()}).build();
    private static final SdkField<String> COMPOSITE_MEMBER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompositeMemberIdentifier").getter(CopyJob.getter(CopyJob::compositeMemberIdentifier)).setter(CopyJob.setter(Builder::compositeMemberIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositeMemberIdentifier").build()}).build();
    private static final SdkField<Long> NUMBER_OF_CHILD_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfChildJobs").getter(CopyJob.getter(CopyJob::numberOfChildJobs)).setter(CopyJob.setter(Builder::numberOfChildJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfChildJobs").build()}).build();
    private static final SdkField<Map<String, Long>> CHILD_JOBS_IN_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ChildJobsInState").getter(CopyJob.getter(CopyJob::childJobsInStateAsStrings)).setter(CopyJob.setter(Builder::childJobsInStateWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChildJobsInState").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceName").getter(CopyJob.getter(CopyJob::resourceName)).setter(CopyJob.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()}).build();
    private static final SdkField<String> MESSAGE_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageCategory").getter(CopyJob.getter(CopyJob::messageCategory)).setter(CopyJob.setter(Builder::messageCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageCategory").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, COPY_JOB_ID_FIELD, SOURCE_BACKUP_VAULT_ARN_FIELD, SOURCE_RECOVERY_POINT_ARN_FIELD, DESTINATION_BACKUP_VAULT_ARN_FIELD, DESTINATION_RECOVERY_POINT_ARN_FIELD, RESOURCE_ARN_FIELD, CREATION_DATE_FIELD, COMPLETION_DATE_FIELD, STATE_FIELD, STATUS_MESSAGE_FIELD, BACKUP_SIZE_IN_BYTES_FIELD, IAM_ROLE_ARN_FIELD, CREATED_BY_FIELD, RESOURCE_TYPE_FIELD, PARENT_JOB_ID_FIELD, IS_PARENT_FIELD, COMPOSITE_MEMBER_IDENTIFIER_FIELD, NUMBER_OF_CHILD_JOBS_FIELD, CHILD_JOBS_IN_STATE_FIELD, RESOURCE_NAME_FIELD, MESSAGE_CATEGORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CopyJob.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String copyJobId;
    private final String sourceBackupVaultArn;
    private final String sourceRecoveryPointArn;
    private final String destinationBackupVaultArn;
    private final String destinationRecoveryPointArn;
    private final String resourceArn;
    private final Instant creationDate;
    private final Instant completionDate;
    private final String state;
    private final String statusMessage;
    private final Long backupSizeInBytes;
    private final String iamRoleArn;
    private final RecoveryPointCreator createdBy;
    private final String resourceType;
    private final String parentJobId;
    private final Boolean isParent;
    private final String compositeMemberIdentifier;
    private final Long numberOfChildJobs;
    private final Map<String, Long> childJobsInState;
    private final String resourceName;
    private final String messageCategory;

    private CopyJob(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.copyJobId = builder.copyJobId;
        this.sourceBackupVaultArn = builder.sourceBackupVaultArn;
        this.sourceRecoveryPointArn = builder.sourceRecoveryPointArn;
        this.destinationBackupVaultArn = builder.destinationBackupVaultArn;
        this.destinationRecoveryPointArn = builder.destinationRecoveryPointArn;
        this.resourceArn = builder.resourceArn;
        this.creationDate = builder.creationDate;
        this.completionDate = builder.completionDate;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
        this.backupSizeInBytes = builder.backupSizeInBytes;
        this.iamRoleArn = builder.iamRoleArn;
        this.createdBy = builder.createdBy;
        this.resourceType = builder.resourceType;
        this.parentJobId = builder.parentJobId;
        this.isParent = builder.isParent;
        this.compositeMemberIdentifier = builder.compositeMemberIdentifier;
        this.numberOfChildJobs = builder.numberOfChildJobs;
        this.childJobsInState = builder.childJobsInState;
        this.resourceName = builder.resourceName;
        this.messageCategory = builder.messageCategory;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String copyJobId() {
        return this.copyJobId;
    }

    public final String sourceBackupVaultArn() {
        return this.sourceBackupVaultArn;
    }

    public final String sourceRecoveryPointArn() {
        return this.sourceRecoveryPointArn;
    }

    public final String destinationBackupVaultArn() {
        return this.destinationBackupVaultArn;
    }

    public final String destinationRecoveryPointArn() {
        return this.destinationRecoveryPointArn;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant completionDate() {
        return this.completionDate;
    }

    public final CopyJobState state() {
        return CopyJobState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Long backupSizeInBytes() {
        return this.backupSizeInBytes;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final RecoveryPointCreator createdBy() {
        return this.createdBy;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String parentJobId() {
        return this.parentJobId;
    }

    public final Boolean isParent() {
        return this.isParent;
    }

    public final String compositeMemberIdentifier() {
        return this.compositeMemberIdentifier;
    }

    public final Long numberOfChildJobs() {
        return this.numberOfChildJobs;
    }

    public final Map<CopyJobState, Long> childJobsInState() {
        return CopyJobChildJobsInStateCopier.copyStringToEnum(this.childJobsInState);
    }

    public final boolean hasChildJobsInState() {
        return this.childJobsInState != null && !(this.childJobsInState instanceof SdkAutoConstructMap);
    }

    public final Map<String, Long> childJobsInStateAsStrings() {
        return this.childJobsInState;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final String messageCategory() {
        return this.messageCategory;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isParent());
        hashCode = 31 * hashCode + Objects.hashCode(this.compositeMemberIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfChildJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChildJobsInState() ? this.childJobsInStateAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageCategory());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyJob)) {
            return false;
        }
        CopyJob other = (CopyJob)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.copyJobId(), other.copyJobId()) && Objects.equals(this.sourceBackupVaultArn(), other.sourceBackupVaultArn()) && Objects.equals(this.sourceRecoveryPointArn(), other.sourceRecoveryPointArn()) && Objects.equals(this.destinationBackupVaultArn(), other.destinationBackupVaultArn()) && Objects.equals(this.destinationRecoveryPointArn(), other.destinationRecoveryPointArn()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.completionDate(), other.completionDate()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.backupSizeInBytes(), other.backupSizeInBytes()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.parentJobId(), other.parentJobId()) && Objects.equals(this.isParent(), other.isParent()) && Objects.equals(this.compositeMemberIdentifier(), other.compositeMemberIdentifier()) && Objects.equals(this.numberOfChildJobs(), other.numberOfChildJobs()) && this.hasChildJobsInState() == other.hasChildJobsInState() && Objects.equals(this.childJobsInStateAsStrings(), other.childJobsInStateAsStrings()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.messageCategory(), other.messageCategory());
    }

    public final String toString() {
        return ToString.builder((String)"CopyJob").add("AccountId", (Object)this.accountId()).add("CopyJobId", (Object)this.copyJobId()).add("SourceBackupVaultArn", (Object)this.sourceBackupVaultArn()).add("SourceRecoveryPointArn", (Object)this.sourceRecoveryPointArn()).add("DestinationBackupVaultArn", (Object)this.destinationBackupVaultArn()).add("DestinationRecoveryPointArn", (Object)this.destinationRecoveryPointArn()).add("ResourceArn", (Object)this.resourceArn()).add("CreationDate", (Object)this.creationDate()).add("CompletionDate", (Object)this.completionDate()).add("State", (Object)this.stateAsString()).add("StatusMessage", (Object)this.statusMessage()).add("BackupSizeInBytes", (Object)this.backupSizeInBytes()).add("IamRoleArn", (Object)this.iamRoleArn()).add("CreatedBy", (Object)this.createdBy()).add("ResourceType", (Object)this.resourceType()).add("ParentJobId", (Object)this.parentJobId()).add("IsParent", (Object)this.isParent()).add("CompositeMemberIdentifier", (Object)this.compositeMemberIdentifier()).add("NumberOfChildJobs", (Object)this.numberOfChildJobs()).add("ChildJobsInState", this.hasChildJobsInState() ? this.childJobsInStateAsStrings() : null).add("ResourceName", (Object)this.resourceName()).add("MessageCategory", (Object)this.messageCategory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "CopyJobId": {
                return Optional.ofNullable(clazz.cast(this.copyJobId()));
            }
            case "SourceBackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.sourceBackupVaultArn()));
            }
            case "SourceRecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.sourceRecoveryPointArn()));
            }
            case "DestinationBackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.destinationBackupVaultArn()));
            }
            case "DestinationRecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.destinationRecoveryPointArn()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "CompletionDate": {
                return Optional.ofNullable(clazz.cast(this.completionDate()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "BackupSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.backupSizeInBytes()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ParentJobId": {
                return Optional.ofNullable(clazz.cast(this.parentJobId()));
            }
            case "IsParent": {
                return Optional.ofNullable(clazz.cast(this.isParent()));
            }
            case "CompositeMemberIdentifier": {
                return Optional.ofNullable(clazz.cast(this.compositeMemberIdentifier()));
            }
            case "NumberOfChildJobs": {
                return Optional.ofNullable(clazz.cast(this.numberOfChildJobs()));
            }
            case "ChildJobsInState": {
                return Optional.ofNullable(clazz.cast(this.childJobsInStateAsStrings()));
            }
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "MessageCategory": {
                return Optional.ofNullable(clazz.cast(this.messageCategory()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("CopyJobId", COPY_JOB_ID_FIELD);
        map.put("SourceBackupVaultArn", SOURCE_BACKUP_VAULT_ARN_FIELD);
        map.put("SourceRecoveryPointArn", SOURCE_RECOVERY_POINT_ARN_FIELD);
        map.put("DestinationBackupVaultArn", DESTINATION_BACKUP_VAULT_ARN_FIELD);
        map.put("DestinationRecoveryPointArn", DESTINATION_RECOVERY_POINT_ARN_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("CompletionDate", COMPLETION_DATE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("BackupSizeInBytes", BACKUP_SIZE_IN_BYTES_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ParentJobId", PARENT_JOB_ID_FIELD);
        map.put("IsParent", IS_PARENT_FIELD);
        map.put("CompositeMemberIdentifier", COMPOSITE_MEMBER_IDENTIFIER_FIELD);
        map.put("NumberOfChildJobs", NUMBER_OF_CHILD_JOBS_FIELD);
        map.put("ChildJobsInState", CHILD_JOBS_IN_STATE_FIELD);
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        map.put("MessageCategory", MESSAGE_CATEGORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyJob, T> g) {
        return obj -> g.apply((CopyJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String copyJobId;
        private String sourceBackupVaultArn;
        private String sourceRecoveryPointArn;
        private String destinationBackupVaultArn;
        private String destinationRecoveryPointArn;
        private String resourceArn;
        private Instant creationDate;
        private Instant completionDate;
        private String state;
        private String statusMessage;
        private Long backupSizeInBytes;
        private String iamRoleArn;
        private RecoveryPointCreator createdBy;
        private String resourceType;
        private String parentJobId;
        private Boolean isParent;
        private String compositeMemberIdentifier;
        private Long numberOfChildJobs;
        private Map<String, Long> childJobsInState = DefaultSdkAutoConstructMap.getInstance();
        private String resourceName;
        private String messageCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyJob model) {
            this.accountId(model.accountId);
            this.copyJobId(model.copyJobId);
            this.sourceBackupVaultArn(model.sourceBackupVaultArn);
            this.sourceRecoveryPointArn(model.sourceRecoveryPointArn);
            this.destinationBackupVaultArn(model.destinationBackupVaultArn);
            this.destinationRecoveryPointArn(model.destinationRecoveryPointArn);
            this.resourceArn(model.resourceArn);
            this.creationDate(model.creationDate);
            this.completionDate(model.completionDate);
            this.state(model.state);
            this.statusMessage(model.statusMessage);
            this.backupSizeInBytes(model.backupSizeInBytes);
            this.iamRoleArn(model.iamRoleArn);
            this.createdBy(model.createdBy);
            this.resourceType(model.resourceType);
            this.parentJobId(model.parentJobId);
            this.isParent(model.isParent);
            this.compositeMemberIdentifier(model.compositeMemberIdentifier);
            this.numberOfChildJobs(model.numberOfChildJobs);
            this.childJobsInStateWithStrings(model.childJobsInState);
            this.resourceName(model.resourceName);
            this.messageCategory(model.messageCategory);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getCopyJobId() {
            return this.copyJobId;
        }

        public final void setCopyJobId(String copyJobId) {
            this.copyJobId = copyJobId;
        }

        @Override
        public final Builder copyJobId(String copyJobId) {
            this.copyJobId = copyJobId;
            return this;
        }

        public final String getSourceBackupVaultArn() {
            return this.sourceBackupVaultArn;
        }

        public final void setSourceBackupVaultArn(String sourceBackupVaultArn) {
            this.sourceBackupVaultArn = sourceBackupVaultArn;
        }

        @Override
        public final Builder sourceBackupVaultArn(String sourceBackupVaultArn) {
            this.sourceBackupVaultArn = sourceBackupVaultArn;
            return this;
        }

        public final String getSourceRecoveryPointArn() {
            return this.sourceRecoveryPointArn;
        }

        public final void setSourceRecoveryPointArn(String sourceRecoveryPointArn) {
            this.sourceRecoveryPointArn = sourceRecoveryPointArn;
        }

        @Override
        public final Builder sourceRecoveryPointArn(String sourceRecoveryPointArn) {
            this.sourceRecoveryPointArn = sourceRecoveryPointArn;
            return this;
        }

        public final String getDestinationBackupVaultArn() {
            return this.destinationBackupVaultArn;
        }

        public final void setDestinationBackupVaultArn(String destinationBackupVaultArn) {
            this.destinationBackupVaultArn = destinationBackupVaultArn;
        }

        @Override
        public final Builder destinationBackupVaultArn(String destinationBackupVaultArn) {
            this.destinationBackupVaultArn = destinationBackupVaultArn;
            return this;
        }

        public final String getDestinationRecoveryPointArn() {
            return this.destinationRecoveryPointArn;
        }

        public final void setDestinationRecoveryPointArn(String destinationRecoveryPointArn) {
            this.destinationRecoveryPointArn = destinationRecoveryPointArn;
        }

        @Override
        public final Builder destinationRecoveryPointArn(String destinationRecoveryPointArn) {
            this.destinationRecoveryPointArn = destinationRecoveryPointArn;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getCompletionDate() {
            return this.completionDate;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CopyJobState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Long getBackupSizeInBytes() {
            return this.backupSizeInBytes;
        }

        public final void setBackupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
        }

        @Override
        public final Builder backupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final RecoveryPointCreator.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(RecoveryPointCreator.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(RecoveryPointCreator createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getParentJobId() {
            return this.parentJobId;
        }

        public final void setParentJobId(String parentJobId) {
            this.parentJobId = parentJobId;
        }

        @Override
        public final Builder parentJobId(String parentJobId) {
            this.parentJobId = parentJobId;
            return this;
        }

        public final Boolean getIsParent() {
            return this.isParent;
        }

        public final void setIsParent(Boolean isParent) {
            this.isParent = isParent;
        }

        @Override
        public final Builder isParent(Boolean isParent) {
            this.isParent = isParent;
            return this;
        }

        public final String getCompositeMemberIdentifier() {
            return this.compositeMemberIdentifier;
        }

        public final void setCompositeMemberIdentifier(String compositeMemberIdentifier) {
            this.compositeMemberIdentifier = compositeMemberIdentifier;
        }

        @Override
        public final Builder compositeMemberIdentifier(String compositeMemberIdentifier) {
            this.compositeMemberIdentifier = compositeMemberIdentifier;
            return this;
        }

        public final Long getNumberOfChildJobs() {
            return this.numberOfChildJobs;
        }

        public final void setNumberOfChildJobs(Long numberOfChildJobs) {
            this.numberOfChildJobs = numberOfChildJobs;
        }

        @Override
        public final Builder numberOfChildJobs(Long numberOfChildJobs) {
            this.numberOfChildJobs = numberOfChildJobs;
            return this;
        }

        public final Map<String, Long> getChildJobsInState() {
            if (this.childJobsInState instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.childJobsInState;
        }

        public final void setChildJobsInState(Map<String, Long> childJobsInState) {
            this.childJobsInState = CopyJobChildJobsInStateCopier.copy(childJobsInState);
        }

        @Override
        public final Builder childJobsInStateWithStrings(Map<String, Long> childJobsInState) {
            this.childJobsInState = CopyJobChildJobsInStateCopier.copy(childJobsInState);
            return this;
        }

        @Override
        public final Builder childJobsInState(Map<CopyJobState, Long> childJobsInState) {
            this.childJobsInState = CopyJobChildJobsInStateCopier.copyEnumToString(childJobsInState);
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getMessageCategory() {
            return this.messageCategory;
        }

        public final void setMessageCategory(String messageCategory) {
            this.messageCategory = messageCategory;
        }

        @Override
        public final Builder messageCategory(String messageCategory) {
            this.messageCategory = messageCategory;
            return this;
        }

        public CopyJob build() {
            return new CopyJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CopyJob> {
        public Builder accountId(String var1);

        public Builder copyJobId(String var1);

        public Builder sourceBackupVaultArn(String var1);

        public Builder sourceRecoveryPointArn(String var1);

        public Builder destinationBackupVaultArn(String var1);

        public Builder destinationRecoveryPointArn(String var1);

        public Builder resourceArn(String var1);

        public Builder creationDate(Instant var1);

        public Builder completionDate(Instant var1);

        public Builder state(String var1);

        public Builder state(CopyJobState var1);

        public Builder statusMessage(String var1);

        public Builder backupSizeInBytes(Long var1);

        public Builder iamRoleArn(String var1);

        public Builder createdBy(RecoveryPointCreator var1);

        default public Builder createdBy(Consumer<RecoveryPointCreator.Builder> createdBy) {
            return this.createdBy((RecoveryPointCreator)((RecoveryPointCreator.Builder)RecoveryPointCreator.builder().applyMutation(createdBy)).build());
        }

        public Builder resourceType(String var1);

        public Builder parentJobId(String var1);

        public Builder isParent(Boolean var1);

        public Builder compositeMemberIdentifier(String var1);

        public Builder numberOfChildJobs(Long var1);

        public Builder childJobsInStateWithStrings(Map<String, Long> var1);

        public Builder childJobsInState(Map<CopyJobState, Long> var1);

        public Builder resourceName(String var1);

        public Builder messageCategory(String var1);
    }
}

