/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.IndexStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecoveryPointIndexDetailsResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, GetRecoveryPointIndexDetailsResponse> {
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryPointArn").getter(GetRecoveryPointIndexDetailsResponse.getter(GetRecoveryPointIndexDetailsResponse::recoveryPointArn)).setter(GetRecoveryPointIndexDetailsResponse.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultArn").getter(GetRecoveryPointIndexDetailsResponse.getter(GetRecoveryPointIndexDetailsResponse::backupVaultArn)).setter(GetRecoveryPointIndexDetailsResponse.setter(Builder::backupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()}).build();
    private static final SdkField<String> SOURCE_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceResourceArn").getter(GetRecoveryPointIndexDetailsResponse.getter(GetRecoveryPointIndexDetailsResponse::sourceResourceArn)).setter(GetRecoveryPointIndexDetailsResponse.setter(Builder::sourceResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResourceArn").build()}).build();
    private static final SdkField<Instant> INDEX_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("IndexCreationDate").getter(GetRecoveryPointIndexDetailsResponse.getter(GetRecoveryPointIndexDetailsResponse::indexCreationDate)).setter(GetRecoveryPointIndexDetailsResponse.setter(Builder::indexCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexCreationDate").build()}).build();
    private static final SdkField<Instant> INDEX_DELETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("IndexDeletionDate").getter(GetRecoveryPointIndexDetailsResponse.getter(GetRecoveryPointIndexDetailsResponse::indexDeletionDate)).setter(GetRecoveryPointIndexDetailsResponse.setter(Builder::indexDeletionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexDeletionDate").build()}).build();
    private static final SdkField<Instant> INDEX_COMPLETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("IndexCompletionDate").getter(GetRecoveryPointIndexDetailsResponse.getter(GetRecoveryPointIndexDetailsResponse::indexCompletionDate)).setter(GetRecoveryPointIndexDetailsResponse.setter(Builder::indexCompletionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexCompletionDate").build()}).build();
    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexStatus").getter(GetRecoveryPointIndexDetailsResponse.getter(GetRecoveryPointIndexDetailsResponse::indexStatusAsString)).setter(GetRecoveryPointIndexDetailsResponse.setter(Builder::indexStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatus").build()}).build();
    private static final SdkField<String> INDEX_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexStatusMessage").getter(GetRecoveryPointIndexDetailsResponse.getter(GetRecoveryPointIndexDetailsResponse::indexStatusMessage)).setter(GetRecoveryPointIndexDetailsResponse.setter(Builder::indexStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatusMessage").build()}).build();
    private static final SdkField<Long> TOTAL_ITEMS_INDEXED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalItemsIndexed").getter(GetRecoveryPointIndexDetailsResponse.getter(GetRecoveryPointIndexDetailsResponse::totalItemsIndexed)).setter(GetRecoveryPointIndexDetailsResponse.setter(Builder::totalItemsIndexed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalItemsIndexed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINT_ARN_FIELD, BACKUP_VAULT_ARN_FIELD, SOURCE_RESOURCE_ARN_FIELD, INDEX_CREATION_DATE_FIELD, INDEX_DELETION_DATE_FIELD, INDEX_COMPLETION_DATE_FIELD, INDEX_STATUS_FIELD, INDEX_STATUS_MESSAGE_FIELD, TOTAL_ITEMS_INDEXED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRecoveryPointIndexDetailsResponse.memberNameToFieldInitializer();
    private final String recoveryPointArn;
    private final String backupVaultArn;
    private final String sourceResourceArn;
    private final Instant indexCreationDate;
    private final Instant indexDeletionDate;
    private final Instant indexCompletionDate;
    private final String indexStatus;
    private final String indexStatusMessage;
    private final Long totalItemsIndexed;

    private GetRecoveryPointIndexDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.recoveryPointArn = builder.recoveryPointArn;
        this.backupVaultArn = builder.backupVaultArn;
        this.sourceResourceArn = builder.sourceResourceArn;
        this.indexCreationDate = builder.indexCreationDate;
        this.indexDeletionDate = builder.indexDeletionDate;
        this.indexCompletionDate = builder.indexCompletionDate;
        this.indexStatus = builder.indexStatus;
        this.indexStatusMessage = builder.indexStatusMessage;
        this.totalItemsIndexed = builder.totalItemsIndexed;
    }

    public final String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public final String backupVaultArn() {
        return this.backupVaultArn;
    }

    public final String sourceResourceArn() {
        return this.sourceResourceArn;
    }

    public final Instant indexCreationDate() {
        return this.indexCreationDate;
    }

    public final Instant indexDeletionDate() {
        return this.indexDeletionDate;
    }

    public final Instant indexCompletionDate() {
        return this.indexCompletionDate;
    }

    public final IndexStatus indexStatus() {
        return IndexStatus.fromValue(this.indexStatus);
    }

    public final String indexStatusAsString() {
        return this.indexStatus;
    }

    public final String indexStatusMessage() {
        return this.indexStatusMessage;
    }

    public final Long totalItemsIndexed() {
        return this.totalItemsIndexed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexDeletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexCompletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalItemsIndexed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecoveryPointIndexDetailsResponse)) {
            return false;
        }
        GetRecoveryPointIndexDetailsResponse other = (GetRecoveryPointIndexDetailsResponse)((Object)obj);
        return Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.backupVaultArn(), other.backupVaultArn()) && Objects.equals(this.sourceResourceArn(), other.sourceResourceArn()) && Objects.equals(this.indexCreationDate(), other.indexCreationDate()) && Objects.equals(this.indexDeletionDate(), other.indexDeletionDate()) && Objects.equals(this.indexCompletionDate(), other.indexCompletionDate()) && Objects.equals(this.indexStatusAsString(), other.indexStatusAsString()) && Objects.equals(this.indexStatusMessage(), other.indexStatusMessage()) && Objects.equals(this.totalItemsIndexed(), other.totalItemsIndexed());
    }

    public final String toString() {
        return ToString.builder((String)"GetRecoveryPointIndexDetailsResponse").add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("BackupVaultArn", (Object)this.backupVaultArn()).add("SourceResourceArn", (Object)this.sourceResourceArn()).add("IndexCreationDate", (Object)this.indexCreationDate()).add("IndexDeletionDate", (Object)this.indexDeletionDate()).add("IndexCompletionDate", (Object)this.indexCompletionDate()).add("IndexStatus", (Object)this.indexStatusAsString()).add("IndexStatusMessage", (Object)this.indexStatusMessage()).add("TotalItemsIndexed", (Object)this.totalItemsIndexed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "BackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.backupVaultArn()));
            }
            case "SourceResourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceResourceArn()));
            }
            case "IndexCreationDate": {
                return Optional.ofNullable(clazz.cast(this.indexCreationDate()));
            }
            case "IndexDeletionDate": {
                return Optional.ofNullable(clazz.cast(this.indexDeletionDate()));
            }
            case "IndexCompletionDate": {
                return Optional.ofNullable(clazz.cast(this.indexCompletionDate()));
            }
            case "IndexStatus": {
                return Optional.ofNullable(clazz.cast(this.indexStatusAsString()));
            }
            case "IndexStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.indexStatusMessage()));
            }
            case "TotalItemsIndexed": {
                return Optional.ofNullable(clazz.cast(this.totalItemsIndexed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RecoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("BackupVaultArn", BACKUP_VAULT_ARN_FIELD);
        map.put("SourceResourceArn", SOURCE_RESOURCE_ARN_FIELD);
        map.put("IndexCreationDate", INDEX_CREATION_DATE_FIELD);
        map.put("IndexDeletionDate", INDEX_DELETION_DATE_FIELD);
        map.put("IndexCompletionDate", INDEX_COMPLETION_DATE_FIELD);
        map.put("IndexStatus", INDEX_STATUS_FIELD);
        map.put("IndexStatusMessage", INDEX_STATUS_MESSAGE_FIELD);
        map.put("TotalItemsIndexed", TOTAL_ITEMS_INDEXED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRecoveryPointIndexDetailsResponse, T> g) {
        return obj -> g.apply((GetRecoveryPointIndexDetailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String recoveryPointArn;
        private String backupVaultArn;
        private String sourceResourceArn;
        private Instant indexCreationDate;
        private Instant indexDeletionDate;
        private Instant indexCompletionDate;
        private String indexStatus;
        private String indexStatusMessage;
        private Long totalItemsIndexed;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecoveryPointIndexDetailsResponse model) {
            super(model);
            this.recoveryPointArn(model.recoveryPointArn);
            this.backupVaultArn(model.backupVaultArn);
            this.sourceResourceArn(model.sourceResourceArn);
            this.indexCreationDate(model.indexCreationDate);
            this.indexDeletionDate(model.indexDeletionDate);
            this.indexCompletionDate(model.indexCompletionDate);
            this.indexStatus(model.indexStatus);
            this.indexStatusMessage(model.indexStatusMessage);
            this.totalItemsIndexed(model.totalItemsIndexed);
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getBackupVaultArn() {
            return this.backupVaultArn;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final String getSourceResourceArn() {
            return this.sourceResourceArn;
        }

        public final void setSourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
        }

        @Override
        public final Builder sourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
            return this;
        }

        public final Instant getIndexCreationDate() {
            return this.indexCreationDate;
        }

        public final void setIndexCreationDate(Instant indexCreationDate) {
            this.indexCreationDate = indexCreationDate;
        }

        @Override
        public final Builder indexCreationDate(Instant indexCreationDate) {
            this.indexCreationDate = indexCreationDate;
            return this;
        }

        public final Instant getIndexDeletionDate() {
            return this.indexDeletionDate;
        }

        public final void setIndexDeletionDate(Instant indexDeletionDate) {
            this.indexDeletionDate = indexDeletionDate;
        }

        @Override
        public final Builder indexDeletionDate(Instant indexDeletionDate) {
            this.indexDeletionDate = indexDeletionDate;
            return this;
        }

        public final Instant getIndexCompletionDate() {
            return this.indexCompletionDate;
        }

        public final void setIndexCompletionDate(Instant indexCompletionDate) {
            this.indexCompletionDate = indexCompletionDate;
        }

        @Override
        public final Builder indexCompletionDate(Instant indexCompletionDate) {
            this.indexCompletionDate = indexCompletionDate;
            return this;
        }

        public final String getIndexStatus() {
            return this.indexStatus;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        public final String getIndexStatusMessage() {
            return this.indexStatusMessage;
        }

        public final void setIndexStatusMessage(String indexStatusMessage) {
            this.indexStatusMessage = indexStatusMessage;
        }

        @Override
        public final Builder indexStatusMessage(String indexStatusMessage) {
            this.indexStatusMessage = indexStatusMessage;
            return this;
        }

        public final Long getTotalItemsIndexed() {
            return this.totalItemsIndexed;
        }

        public final void setTotalItemsIndexed(Long totalItemsIndexed) {
            this.totalItemsIndexed = totalItemsIndexed;
        }

        @Override
        public final Builder totalItemsIndexed(Long totalItemsIndexed) {
            this.totalItemsIndexed = totalItemsIndexed;
            return this;
        }

        @Override
        public GetRecoveryPointIndexDetailsResponse build() {
            return new GetRecoveryPointIndexDetailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecoveryPointIndexDetailsResponse> {
        public Builder recoveryPointArn(String var1);

        public Builder backupVaultArn(String var1);

        public Builder sourceResourceArn(String var1);

        public Builder indexCreationDate(Instant var1);

        public Builder indexDeletionDate(Instant var1);

        public Builder indexCompletionDate(Instant var1);

        public Builder indexStatus(String var1);

        public Builder indexStatus(IndexStatus var1);

        public Builder indexStatusMessage(String var1);

        public Builder totalItemsIndexed(Long var1);
    }
}

