/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.LegalHoldStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LegalHold
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LegalHold> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(LegalHold.getter(LegalHold::title)).setter(LegalHold.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(LegalHold.getter(LegalHold::statusAsString)).setter(LegalHold.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(LegalHold.getter(LegalHold::description)).setter(LegalHold.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> LEGAL_HOLD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LegalHoldId").getter(LegalHold.getter(LegalHold::legalHoldId)).setter(LegalHold.setter(Builder::legalHoldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegalHoldId").build()}).build();
    private static final SdkField<String> LEGAL_HOLD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LegalHoldArn").getter(LegalHold.getter(LegalHold::legalHoldArn)).setter(LegalHold.setter(Builder::legalHoldArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegalHoldArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(LegalHold.getter(LegalHold::creationDate)).setter(LegalHold.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> CANCELLATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CancellationDate").getter(LegalHold.getter(LegalHold::cancellationDate)).setter(LegalHold.setter(Builder::cancellationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancellationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, LEGAL_HOLD_ID_FIELD, LEGAL_HOLD_ARN_FIELD, CREATION_DATE_FIELD, CANCELLATION_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LegalHold.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String status;
    private final String description;
    private final String legalHoldId;
    private final String legalHoldArn;
    private final Instant creationDate;
    private final Instant cancellationDate;

    private LegalHold(BuilderImpl builder) {
        this.title = builder.title;
        this.status = builder.status;
        this.description = builder.description;
        this.legalHoldId = builder.legalHoldId;
        this.legalHoldArn = builder.legalHoldArn;
        this.creationDate = builder.creationDate;
        this.cancellationDate = builder.cancellationDate;
    }

    public final String title() {
        return this.title;
    }

    public final LegalHoldStatus status() {
        return LegalHoldStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String description() {
        return this.description;
    }

    public final String legalHoldId() {
        return this.legalHoldId;
    }

    public final String legalHoldArn() {
        return this.legalHoldArn;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant cancellationDate() {
        return this.cancellationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.legalHoldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.legalHoldArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.cancellationDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LegalHold)) {
            return false;
        }
        LegalHold other = (LegalHold)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.legalHoldId(), other.legalHoldId()) && Objects.equals(this.legalHoldArn(), other.legalHoldArn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.cancellationDate(), other.cancellationDate());
    }

    public final String toString() {
        return ToString.builder((String)"LegalHold").add("Title", (Object)this.title()).add("Status", (Object)this.statusAsString()).add("Description", (Object)this.description()).add("LegalHoldId", (Object)this.legalHoldId()).add("LegalHoldArn", (Object)this.legalHoldArn()).add("CreationDate", (Object)this.creationDate()).add("CancellationDate", (Object)this.cancellationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LegalHoldId": {
                return Optional.ofNullable(clazz.cast(this.legalHoldId()));
            }
            case "LegalHoldArn": {
                return Optional.ofNullable(clazz.cast(this.legalHoldArn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "CancellationDate": {
                return Optional.ofNullable(clazz.cast(this.cancellationDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Title", TITLE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("LegalHoldId", LEGAL_HOLD_ID_FIELD);
        map.put("LegalHoldArn", LEGAL_HOLD_ARN_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("CancellationDate", CANCELLATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LegalHold, T> g) {
        return obj -> g.apply((LegalHold)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private String status;
        private String description;
        private String legalHoldId;
        private String legalHoldArn;
        private Instant creationDate;
        private Instant cancellationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(LegalHold model) {
            this.title(model.title);
            this.status(model.status);
            this.description(model.description);
            this.legalHoldId(model.legalHoldId);
            this.legalHoldArn(model.legalHoldArn);
            this.creationDate(model.creationDate);
            this.cancellationDate(model.cancellationDate);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LegalHoldStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLegalHoldId() {
            return this.legalHoldId;
        }

        public final void setLegalHoldId(String legalHoldId) {
            this.legalHoldId = legalHoldId;
        }

        @Override
        public final Builder legalHoldId(String legalHoldId) {
            this.legalHoldId = legalHoldId;
            return this;
        }

        public final String getLegalHoldArn() {
            return this.legalHoldArn;
        }

        public final void setLegalHoldArn(String legalHoldArn) {
            this.legalHoldArn = legalHoldArn;
        }

        @Override
        public final Builder legalHoldArn(String legalHoldArn) {
            this.legalHoldArn = legalHoldArn;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getCancellationDate() {
            return this.cancellationDate;
        }

        public final void setCancellationDate(Instant cancellationDate) {
            this.cancellationDate = cancellationDate;
        }

        @Override
        public final Builder cancellationDate(Instant cancellationDate) {
            this.cancellationDate = cancellationDate;
            return this;
        }

        public LegalHold build() {
            return new LegalHold(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LegalHold> {
        public Builder title(String var1);

        public Builder status(String var1);

        public Builder status(LegalHoldStatus var1);

        public Builder description(String var1);

        public Builder legalHoldId(String var1);

        public Builder legalHoldArn(String var1);

        public Builder creationDate(Instant var1);

        public Builder cancellationDate(Instant var1);
    }
}

