/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse;

public class ListRecoveryPointsByResourceIterable
implements SdkIterable<ListRecoveryPointsByResourceResponse> {
    private final BackupClient client;
    private final ListRecoveryPointsByResourceRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecoveryPointsByResourceIterable(BackupClient client, ListRecoveryPointsByResourceRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRecoveryPointsByResourceResponseFetcher();
    }

    public Iterator<ListRecoveryPointsByResourceResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListRecoveryPointsByResourceIterable resume(ListRecoveryPointsByResourceResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListRecoveryPointsByResourceIterable(this.client, (ListRecoveryPointsByResourceRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListRecoveryPointsByResourceIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListRecoveryPointsByResourceResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListRecoveryPointsByResourceResponseFetcher
    implements SyncPageFetcher<ListRecoveryPointsByResourceResponse> {
        private ListRecoveryPointsByResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListRecoveryPointsByResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecoveryPointsByResourceResponse nextPage(ListRecoveryPointsByResourceResponse previousPage) {
            if (previousPage == null) {
                return ListRecoveryPointsByResourceIterable.this.client.listRecoveryPointsByResource(ListRecoveryPointsByResourceIterable.this.firstRequest);
            }
            return ListRecoveryPointsByResourceIterable.this.client.listRecoveryPointsByResource((ListRecoveryPointsByResourceRequest)((Object)ListRecoveryPointsByResourceIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

