/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse;

public class ListBackupSelectionsIterable
implements SdkIterable<ListBackupSelectionsResponse> {
    private final BackupClient client;
    private final ListBackupSelectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBackupSelectionsIterable(BackupClient client, ListBackupSelectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBackupSelectionsResponseFetcher();
    }

    public Iterator<ListBackupSelectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListBackupSelectionsIterable resume(ListBackupSelectionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListBackupSelectionsIterable(this.client, (ListBackupSelectionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListBackupSelectionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListBackupSelectionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListBackupSelectionsResponseFetcher
    implements SyncPageFetcher<ListBackupSelectionsResponse> {
        private ListBackupSelectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListBackupSelectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBackupSelectionsResponse nextPage(ListBackupSelectionsResponse previousPage) {
            if (previousPage == null) {
                return ListBackupSelectionsIterable.this.client.listBackupSelections(ListBackupSelectionsIterable.this.firstRequest);
            }
            return ListBackupSelectionsIterable.this.client.listBackupSelections((ListBackupSelectionsRequest)((Object)ListBackupSelectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

