/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.ComplianceResourceIdListCopier;
import software.amazon.awssdk.services.backup.model.ResourceTypeListCopier;
import software.amazon.awssdk.services.backup.model._stringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ControlScope
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ControlScope> {
    private static final SdkField<List<String>> COMPLIANCE_RESOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ComplianceResourceIds").getter(ControlScope.getter(ControlScope::complianceResourceIds)).setter(ControlScope.setter(Builder::complianceResourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceResourceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> COMPLIANCE_RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ComplianceResourceTypes").getter(ControlScope.getter(ControlScope::complianceResourceTypes)).setter(ControlScope.setter(Builder::complianceResourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(ControlScope.getter(ControlScope::tags)).setter(ControlScope.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_RESOURCE_IDS_FIELD, COMPLIANCE_RESOURCE_TYPES_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ComplianceResourceIds", COMPLIANCE_RESOURCE_IDS_FIELD);
            this.put("ComplianceResourceTypes", COMPLIANCE_RESOURCE_TYPES_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> complianceResourceIds;
    private final List<String> complianceResourceTypes;
    private final Map<String, String> tags;

    private ControlScope(BuilderImpl builder) {
        this.complianceResourceIds = builder.complianceResourceIds;
        this.complianceResourceTypes = builder.complianceResourceTypes;
        this.tags = builder.tags;
    }

    public final boolean hasComplianceResourceIds() {
        return this.complianceResourceIds != null && !(this.complianceResourceIds instanceof SdkAutoConstructList);
    }

    public final List<String> complianceResourceIds() {
        return this.complianceResourceIds;
    }

    public final boolean hasComplianceResourceTypes() {
        return this.complianceResourceTypes != null && !(this.complianceResourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> complianceResourceTypes() {
        return this.complianceResourceTypes;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComplianceResourceIds() ? this.complianceResourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComplianceResourceTypes() ? this.complianceResourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlScope)) {
            return false;
        }
        ControlScope other = (ControlScope)obj;
        return this.hasComplianceResourceIds() == other.hasComplianceResourceIds() && Objects.equals(this.complianceResourceIds(), other.complianceResourceIds()) && this.hasComplianceResourceTypes() == other.hasComplianceResourceTypes() && Objects.equals(this.complianceResourceTypes(), other.complianceResourceTypes()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ControlScope").add("ComplianceResourceIds", this.hasComplianceResourceIds() ? this.complianceResourceIds() : null).add("ComplianceResourceTypes", this.hasComplianceResourceTypes() ? this.complianceResourceTypes() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceResourceIds": {
                return Optional.ofNullable(clazz.cast(this.complianceResourceIds()));
            }
            case "ComplianceResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.complianceResourceTypes()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ControlScope, T> g) {
        return obj -> g.apply((ControlScope)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> complianceResourceIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> complianceResourceTypes = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ControlScope model) {
            this.complianceResourceIds(model.complianceResourceIds);
            this.complianceResourceTypes(model.complianceResourceTypes);
            this.tags(model.tags);
        }

        public final Collection<String> getComplianceResourceIds() {
            if (this.complianceResourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.complianceResourceIds;
        }

        public final void setComplianceResourceIds(Collection<String> complianceResourceIds) {
            this.complianceResourceIds = ComplianceResourceIdListCopier.copy(complianceResourceIds);
        }

        @Override
        public final Builder complianceResourceIds(Collection<String> complianceResourceIds) {
            this.complianceResourceIds = ComplianceResourceIdListCopier.copy(complianceResourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceResourceIds(String ... complianceResourceIds) {
            this.complianceResourceIds(Arrays.asList(complianceResourceIds));
            return this;
        }

        public final Collection<String> getComplianceResourceTypes() {
            if (this.complianceResourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.complianceResourceTypes;
        }

        public final void setComplianceResourceTypes(Collection<String> complianceResourceTypes) {
            this.complianceResourceTypes = ResourceTypeListCopier.copy(complianceResourceTypes);
        }

        @Override
        public final Builder complianceResourceTypes(Collection<String> complianceResourceTypes) {
            this.complianceResourceTypes = ResourceTypeListCopier.copy(complianceResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceResourceTypes(String ... complianceResourceTypes) {
            this.complianceResourceTypes(Arrays.asList(complianceResourceTypes));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = _stringMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = _stringMapCopier.copy(tags);
            return this;
        }

        public ControlScope build() {
            return new ControlScope(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ControlScope> {
        public Builder complianceResourceIds(Collection<String> var1);

        public Builder complianceResourceIds(String ... var1);

        public Builder complianceResourceTypes(Collection<String> var1);

        public Builder complianceResourceTypes(String ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

