/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupJobSummary;
import software.amazon.awssdk.services.backup.model.BackupJobSummaryListCopier;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBackupJobSummariesResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListBackupJobSummariesResponse> {
    private static final SdkField<List<BackupJobSummary>> BACKUP_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BackupJobSummaries").getter(ListBackupJobSummariesResponse.getter(ListBackupJobSummariesResponse::backupJobSummaries)).setter(ListBackupJobSummariesResponse.setter(Builder::backupJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BackupJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AGGREGATION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AggregationPeriod").getter(ListBackupJobSummariesResponse.getter(ListBackupJobSummariesResponse::aggregationPeriod)).setter(ListBackupJobSummariesResponse.setter(Builder::aggregationPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationPeriod").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBackupJobSummariesResponse.getter(ListBackupJobSummariesResponse::nextToken)).setter(ListBackupJobSummariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_JOB_SUMMARIES_FIELD, AGGREGATION_PERIOD_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BackupJobSummaries", BACKUP_JOB_SUMMARIES_FIELD);
            this.put("AggregationPeriod", AGGREGATION_PERIOD_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<BackupJobSummary> backupJobSummaries;
    private final String aggregationPeriod;
    private final String nextToken;

    private ListBackupJobSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.backupJobSummaries = builder.backupJobSummaries;
        this.aggregationPeriod = builder.aggregationPeriod;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBackupJobSummaries() {
        return this.backupJobSummaries != null && !(this.backupJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<BackupJobSummary> backupJobSummaries() {
        return this.backupJobSummaries;
    }

    public final String aggregationPeriod() {
        return this.aggregationPeriod;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackupJobSummaries() ? this.backupJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupJobSummariesResponse)) {
            return false;
        }
        ListBackupJobSummariesResponse other = (ListBackupJobSummariesResponse)((Object)obj);
        return this.hasBackupJobSummaries() == other.hasBackupJobSummaries() && Objects.equals(this.backupJobSummaries(), other.backupJobSummaries()) && Objects.equals(this.aggregationPeriod(), other.aggregationPeriod()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBackupJobSummariesResponse").add("BackupJobSummaries", this.hasBackupJobSummaries() ? this.backupJobSummaries() : null).add("AggregationPeriod", (Object)this.aggregationPeriod()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.backupJobSummaries()));
            }
            case "AggregationPeriod": {
                return Optional.ofNullable(clazz.cast(this.aggregationPeriod()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListBackupJobSummariesResponse, T> g) {
        return obj -> g.apply((ListBackupJobSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private List<BackupJobSummary> backupJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String aggregationPeriod;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupJobSummariesResponse model) {
            super(model);
            this.backupJobSummaries(model.backupJobSummaries);
            this.aggregationPeriod(model.aggregationPeriod);
            this.nextToken(model.nextToken);
        }

        public final List<BackupJobSummary.Builder> getBackupJobSummaries() {
            List<BackupJobSummary.Builder> result = BackupJobSummaryListCopier.copyToBuilder(this.backupJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackupJobSummaries(Collection<BackupJobSummary.BuilderImpl> backupJobSummaries) {
            this.backupJobSummaries = BackupJobSummaryListCopier.copyFromBuilder(backupJobSummaries);
        }

        @Override
        public final Builder backupJobSummaries(Collection<BackupJobSummary> backupJobSummaries) {
            this.backupJobSummaries = BackupJobSummaryListCopier.copy(backupJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupJobSummaries(BackupJobSummary ... backupJobSummaries) {
            this.backupJobSummaries(Arrays.asList(backupJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupJobSummaries(Consumer<BackupJobSummary.Builder> ... backupJobSummaries) {
            this.backupJobSummaries(Stream.of(backupJobSummaries).map(c -> (BackupJobSummary)((BackupJobSummary.Builder)BackupJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAggregationPeriod() {
            return this.aggregationPeriod;
        }

        public final void setAggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
        }

        @Override
        public final Builder aggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBackupJobSummariesResponse build() {
            return new ListBackupJobSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBackupJobSummariesResponse> {
        public Builder backupJobSummaries(Collection<BackupJobSummary> var1);

        public Builder backupJobSummaries(BackupJobSummary ... var1);

        public Builder backupJobSummaries(Consumer<BackupJobSummary.Builder> ... var1);

        public Builder aggregationPeriod(String var1);

        public Builder nextToken(String var1);
    }
}

