/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.RestoreTestingSelectionForList;
import software.amazon.awssdk.services.backup.model.RestoreTestingSelectionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRestoreTestingSelectionsResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListRestoreTestingSelectionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRestoreTestingSelectionsResponse.getter(ListRestoreTestingSelectionsResponse::nextToken)).setter(ListRestoreTestingSelectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<RestoreTestingSelectionForList>> RESTORE_TESTING_SELECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RestoreTestingSelections").getter(ListRestoreTestingSelectionsResponse.getter(ListRestoreTestingSelectionsResponse::restoreTestingSelections)).setter(ListRestoreTestingSelectionsResponse.setter(Builder::restoreTestingSelections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingSelections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RestoreTestingSelectionForList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESTORE_TESTING_SELECTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("RestoreTestingSelections", RESTORE_TESTING_SELECTIONS_FIELD);
        }
    });
    private final String nextToken;
    private final List<RestoreTestingSelectionForList> restoreTestingSelections;

    private ListRestoreTestingSelectionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.restoreTestingSelections = builder.restoreTestingSelections;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRestoreTestingSelections() {
        return this.restoreTestingSelections != null && !(this.restoreTestingSelections instanceof SdkAutoConstructList);
    }

    public final List<RestoreTestingSelectionForList> restoreTestingSelections() {
        return this.restoreTestingSelections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRestoreTestingSelections() ? this.restoreTestingSelections() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRestoreTestingSelectionsResponse)) {
            return false;
        }
        ListRestoreTestingSelectionsResponse other = (ListRestoreTestingSelectionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRestoreTestingSelections() == other.hasRestoreTestingSelections() && Objects.equals(this.restoreTestingSelections(), other.restoreTestingSelections());
    }

    public final String toString() {
        return ToString.builder((String)"ListRestoreTestingSelectionsResponse").add("NextToken", (Object)this.nextToken()).add("RestoreTestingSelections", this.hasRestoreTestingSelections() ? this.restoreTestingSelections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RestoreTestingSelections": {
                return Optional.ofNullable(clazz.cast(this.restoreTestingSelections()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRestoreTestingSelectionsResponse, T> g) {
        return obj -> g.apply((ListRestoreTestingSelectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RestoreTestingSelectionForList> restoreTestingSelections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRestoreTestingSelectionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.restoreTestingSelections(model.restoreTestingSelections);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RestoreTestingSelectionForList.Builder> getRestoreTestingSelections() {
            List<RestoreTestingSelectionForList.Builder> result = RestoreTestingSelectionsCopier.copyToBuilder(this.restoreTestingSelections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRestoreTestingSelections(Collection<RestoreTestingSelectionForList.BuilderImpl> restoreTestingSelections) {
            this.restoreTestingSelections = RestoreTestingSelectionsCopier.copyFromBuilder(restoreTestingSelections);
        }

        @Override
        public final Builder restoreTestingSelections(Collection<RestoreTestingSelectionForList> restoreTestingSelections) {
            this.restoreTestingSelections = RestoreTestingSelectionsCopier.copy(restoreTestingSelections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreTestingSelections(RestoreTestingSelectionForList ... restoreTestingSelections) {
            this.restoreTestingSelections(Arrays.asList(restoreTestingSelections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreTestingSelections(Consumer<RestoreTestingSelectionForList.Builder> ... restoreTestingSelections) {
            this.restoreTestingSelections(Stream.of(restoreTestingSelections).map(c -> (RestoreTestingSelectionForList)((RestoreTestingSelectionForList.Builder)RestoreTestingSelectionForList.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRestoreTestingSelectionsResponse build() {
            return new ListRestoreTestingSelectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRestoreTestingSelectionsResponse> {
        public Builder nextToken(String var1);

        public Builder restoreTestingSelections(Collection<RestoreTestingSelectionForList> var1);

        public Builder restoreTestingSelections(RestoreTestingSelectionForList ... var1);

        public Builder restoreTestingSelections(Consumer<RestoreTestingSelectionForList.Builder> ... var1);
    }
}

