/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesResponse;

public class ListRestoreJobSummariesIterable
implements SdkIterable<ListRestoreJobSummariesResponse> {
    private final BackupClient client;
    private final ListRestoreJobSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRestoreJobSummariesIterable(BackupClient client, ListRestoreJobSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRestoreJobSummariesResponseFetcher();
    }

    public Iterator<ListRestoreJobSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListRestoreJobSummariesResponseFetcher
    implements SyncPageFetcher<ListRestoreJobSummariesResponse> {
        private ListRestoreJobSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListRestoreJobSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRestoreJobSummariesResponse nextPage(ListRestoreJobSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListRestoreJobSummariesIterable.this.client.listRestoreJobSummaries(ListRestoreJobSummariesIterable.this.firstRequest);
            }
            return ListRestoreJobSummariesIterable.this.client.listRestoreJobSummaries((ListRestoreJobSummariesRequest)((Object)ListRestoreJobSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

