/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.MetadataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecoveryPointRestoreMetadataResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, GetRecoveryPointRestoreMetadataResponse> {
    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultArn").getter(GetRecoveryPointRestoreMetadataResponse.getter(GetRecoveryPointRestoreMetadataResponse::backupVaultArn)).setter(GetRecoveryPointRestoreMetadataResponse.setter(Builder::backupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()}).build();
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryPointArn").getter(GetRecoveryPointRestoreMetadataResponse.getter(GetRecoveryPointRestoreMetadataResponse::recoveryPointArn)).setter(GetRecoveryPointRestoreMetadataResponse.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()}).build();
    private static final SdkField<Map<String, String>> RESTORE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RestoreMetadata").getter(GetRecoveryPointRestoreMetadataResponse.getter(GetRecoveryPointRestoreMetadataResponse::restoreMetadata)).setter(GetRecoveryPointRestoreMetadataResponse.setter(Builder::restoreMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(GetRecoveryPointRestoreMetadataResponse.getter(GetRecoveryPointRestoreMetadataResponse::resourceType)).setter(GetRecoveryPointRestoreMetadataResponse.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_ARN_FIELD, RECOVERY_POINT_ARN_FIELD, RESTORE_METADATA_FIELD, RESOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BackupVaultArn", BACKUP_VAULT_ARN_FIELD);
            this.put("RecoveryPointArn", RECOVERY_POINT_ARN_FIELD);
            this.put("RestoreMetadata", RESTORE_METADATA_FIELD);
            this.put("ResourceType", RESOURCE_TYPE_FIELD);
        }
    });
    private final String backupVaultArn;
    private final String recoveryPointArn;
    private final Map<String, String> restoreMetadata;
    private final String resourceType;

    private GetRecoveryPointRestoreMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.backupVaultArn = builder.backupVaultArn;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.restoreMetadata = builder.restoreMetadata;
        this.resourceType = builder.resourceType;
    }

    public final String backupVaultArn() {
        return this.backupVaultArn;
    }

    public final String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public final boolean hasRestoreMetadata() {
        return this.restoreMetadata != null && !(this.restoreMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> restoreMetadata() {
        return this.restoreMetadata;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRestoreMetadata() ? this.restoreMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecoveryPointRestoreMetadataResponse)) {
            return false;
        }
        GetRecoveryPointRestoreMetadataResponse other = (GetRecoveryPointRestoreMetadataResponse)((Object)obj);
        return Objects.equals(this.backupVaultArn(), other.backupVaultArn()) && Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && this.hasRestoreMetadata() == other.hasRestoreMetadata() && Objects.equals(this.restoreMetadata(), other.restoreMetadata()) && Objects.equals(this.resourceType(), other.resourceType());
    }

    public final String toString() {
        return ToString.builder((String)"GetRecoveryPointRestoreMetadataResponse").add("BackupVaultArn", (Object)this.backupVaultArn()).add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("RestoreMetadata", (Object)(this.restoreMetadata() == null ? null : "*** Sensitive Data Redacted ***")).add("ResourceType", (Object)this.resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.backupVaultArn()));
            }
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "RestoreMetadata": {
                return Optional.ofNullable(clazz.cast(this.restoreMetadata()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetRecoveryPointRestoreMetadataResponse, T> g) {
        return obj -> g.apply((GetRecoveryPointRestoreMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String backupVaultArn;
        private String recoveryPointArn;
        private Map<String, String> restoreMetadata = DefaultSdkAutoConstructMap.getInstance();
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecoveryPointRestoreMetadataResponse model) {
            super(model);
            this.backupVaultArn(model.backupVaultArn);
            this.recoveryPointArn(model.recoveryPointArn);
            this.restoreMetadata(model.restoreMetadata);
            this.resourceType(model.resourceType);
        }

        public final String getBackupVaultArn() {
            return this.backupVaultArn;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final Map<String, String> getRestoreMetadata() {
            if (this.restoreMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.restoreMetadata;
        }

        public final void setRestoreMetadata(Map<String, String> restoreMetadata) {
            this.restoreMetadata = MetadataCopier.copy(restoreMetadata);
        }

        @Override
        public final Builder restoreMetadata(Map<String, String> restoreMetadata) {
            this.restoreMetadata = MetadataCopier.copy(restoreMetadata);
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public GetRecoveryPointRestoreMetadataResponse build() {
            return new GetRecoveryPointRestoreMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecoveryPointRestoreMetadataResponse> {
        public Builder backupVaultArn(String var1);

        public Builder recoveryPointArn(String var1);

        public Builder restoreMetadata(Map<String, String> var1);

        public Builder resourceType(String var1);
    }
}

