/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldResponse;
import software.amazon.awssdk.services.backup.model.RecoveryPointMember;

public class ListRecoveryPointsByLegalHoldPublisher
implements SdkPublisher<ListRecoveryPointsByLegalHoldResponse> {
    private final BackupAsyncClient client;
    private final ListRecoveryPointsByLegalHoldRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecoveryPointsByLegalHoldPublisher(BackupAsyncClient client, ListRecoveryPointsByLegalHoldRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecoveryPointsByLegalHoldPublisher(BackupAsyncClient client, ListRecoveryPointsByLegalHoldRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecoveryPointsByLegalHoldResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecoveryPointsByLegalHoldResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RecoveryPointMember> recoveryPoints() {
        Function<ListRecoveryPointsByLegalHoldResponse, Iterator> getIterator = response -> {
            if (response != null && response.recoveryPoints() != null) {
                return response.recoveryPoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRecoveryPointsByLegalHoldResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRecoveryPointsByLegalHoldResponseFetcher
    implements AsyncPageFetcher<ListRecoveryPointsByLegalHoldResponse> {
        private ListRecoveryPointsByLegalHoldResponseFetcher() {
        }

        public boolean hasNextPage(ListRecoveryPointsByLegalHoldResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecoveryPointsByLegalHoldResponse> nextPage(ListRecoveryPointsByLegalHoldResponse previousPage) {
            if (previousPage == null) {
                return ListRecoveryPointsByLegalHoldPublisher.this.client.listRecoveryPointsByLegalHold(ListRecoveryPointsByLegalHoldPublisher.this.firstRequest);
            }
            return ListRecoveryPointsByLegalHoldPublisher.this.client.listRecoveryPointsByLegalHold((ListRecoveryPointsByLegalHoldRequest)((Object)ListRecoveryPointsByLegalHoldPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

