/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansResponse;
import software.amazon.awssdk.services.backup.model.RestoreTestingPlanForList;

public class ListRestoreTestingPlansIterable
implements SdkIterable<ListRestoreTestingPlansResponse> {
    private final BackupClient client;
    private final ListRestoreTestingPlansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRestoreTestingPlansIterable(BackupClient client, ListRestoreTestingPlansRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRestoreTestingPlansResponseFetcher();
    }

    public Iterator<ListRestoreTestingPlansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RestoreTestingPlanForList> restoreTestingPlans() {
        Function<ListRestoreTestingPlansResponse, Iterator> getIterator = response -> {
            if (response != null && response.restoreTestingPlans() != null) {
                return response.restoreTestingPlans().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRestoreTestingPlansResponseFetcher
    implements SyncPageFetcher<ListRestoreTestingPlansResponse> {
        private ListRestoreTestingPlansResponseFetcher() {
        }

        public boolean hasNextPage(ListRestoreTestingPlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRestoreTestingPlansResponse nextPage(ListRestoreTestingPlansResponse previousPage) {
            if (previousPage == null) {
                return ListRestoreTestingPlansIterable.this.client.listRestoreTestingPlans(ListRestoreTestingPlansIterable.this.firstRequest);
            }
            return ListRestoreTestingPlansIterable.this.client.listRestoreTestingPlans((ListRestoreTestingPlansRequest)((Object)ListRestoreTestingPlansIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

