/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListBackupJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListBackupJobSummariesResponse;

public class ListBackupJobSummariesPublisher
implements SdkPublisher<ListBackupJobSummariesResponse> {
    private final BackupAsyncClient client;
    private final ListBackupJobSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBackupJobSummariesPublisher(BackupAsyncClient client, ListBackupJobSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBackupJobSummariesPublisher(BackupAsyncClient client, ListBackupJobSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBackupJobSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBackupJobSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListBackupJobSummariesResponseFetcher
    implements AsyncPageFetcher<ListBackupJobSummariesResponse> {
        private ListBackupJobSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListBackupJobSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBackupJobSummariesResponse> nextPage(ListBackupJobSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListBackupJobSummariesPublisher.this.client.listBackupJobSummaries(ListBackupJobSummariesPublisher.this.firstRequest);
            }
            return ListBackupJobSummariesPublisher.this.client.listBackupJobSummaries((ListBackupJobSummariesRequest)((Object)ListBackupJobSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

