/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListBackupJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListBackupJobSummariesResponse;

public class ListBackupJobSummariesIterable
implements SdkIterable<ListBackupJobSummariesResponse> {
    private final BackupClient client;
    private final ListBackupJobSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBackupJobSummariesIterable(BackupClient client, ListBackupJobSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBackupJobSummariesResponseFetcher();
    }

    public Iterator<ListBackupJobSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListBackupJobSummariesResponseFetcher
    implements SyncPageFetcher<ListBackupJobSummariesResponse> {
        private ListBackupJobSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListBackupJobSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBackupJobSummariesResponse nextPage(ListBackupJobSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListBackupJobSummariesIterable.this.client.listBackupJobSummaries(ListBackupJobSummariesIterable.this.firstRequest);
            }
            return ListBackupJobSummariesIterable.this.client.listBackupJobSummaries((ListBackupJobSummariesRequest)((Object)ListBackupJobSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

