/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.BackupJob;
import software.amazon.awssdk.services.backup.model.ListBackupJobsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupJobsResponse;

public class ListBackupJobsPublisher
implements SdkPublisher<ListBackupJobsResponse> {
    private final BackupAsyncClient client;
    private final ListBackupJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBackupJobsPublisher(BackupAsyncClient client, ListBackupJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBackupJobsPublisher(BackupAsyncClient client, ListBackupJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBackupJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBackupJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BackupJob> backupJobs() {
        Function<ListBackupJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.backupJobs() != null) {
                return response.backupJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBackupJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBackupJobsResponseFetcher
    implements AsyncPageFetcher<ListBackupJobsResponse> {
        private ListBackupJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListBackupJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBackupJobsResponse> nextPage(ListBackupJobsResponse previousPage) {
            if (previousPage == null) {
                return ListBackupJobsPublisher.this.client.listBackupJobs(ListBackupJobsPublisher.this.firstRequest);
            }
            return ListBackupJobsPublisher.this.client.listBackupJobs((ListBackupJobsRequest)((Object)ListBackupJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

