/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.RecoveryPointByBackupVault;

public class ListRecoveryPointsByBackupVaultIterable
implements SdkIterable<ListRecoveryPointsByBackupVaultResponse> {
    private final BackupClient client;
    private final ListRecoveryPointsByBackupVaultRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecoveryPointsByBackupVaultIterable(BackupClient client, ListRecoveryPointsByBackupVaultRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRecoveryPointsByBackupVaultResponseFetcher();
    }

    public Iterator<ListRecoveryPointsByBackupVaultResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecoveryPointByBackupVault> recoveryPoints() {
        Function<ListRecoveryPointsByBackupVaultResponse, Iterator> getIterator = response -> {
            if (response != null && response.recoveryPoints() != null) {
                return response.recoveryPoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRecoveryPointsByBackupVaultResponseFetcher
    implements SyncPageFetcher<ListRecoveryPointsByBackupVaultResponse> {
        private ListRecoveryPointsByBackupVaultResponseFetcher() {
        }

        public boolean hasNextPage(ListRecoveryPointsByBackupVaultResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecoveryPointsByBackupVaultResponse nextPage(ListRecoveryPointsByBackupVaultResponse previousPage) {
            if (previousPage == null) {
                return ListRecoveryPointsByBackupVaultIterable.this.client.listRecoveryPointsByBackupVault(ListRecoveryPointsByBackupVaultIterable.this.firstRequest);
            }
            return ListRecoveryPointsByBackupVaultIterable.this.client.listRecoveryPointsByBackupVault((ListRecoveryPointsByBackupVaultRequest)((Object)ListRecoveryPointsByBackupVaultIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

