/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse;
import software.amazon.awssdk.services.backup.model.ProtectedResource;

public class ListProtectedResourcesPublisher
implements SdkPublisher<ListProtectedResourcesResponse> {
    private final BackupAsyncClient client;
    private final ListProtectedResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProtectedResourcesPublisher(BackupAsyncClient client, ListProtectedResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProtectedResourcesPublisher(BackupAsyncClient client, ListProtectedResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProtectedResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProtectedResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProtectedResource> results() {
        Function<ListProtectedResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProtectedResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProtectedResourcesResponseFetcher
    implements AsyncPageFetcher<ListProtectedResourcesResponse> {
        private ListProtectedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListProtectedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProtectedResourcesResponse> nextPage(ListProtectedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListProtectedResourcesPublisher.this.client.listProtectedResources(ListProtectedResourcesPublisher.this.firstRequest);
            }
            return ListProtectedResourcesPublisher.this.client.listProtectedResources((ListProtectedResourcesRequest)((Object)ListProtectedResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

