/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse;

public class ListBackupPlanVersionsPublisher
implements SdkPublisher<ListBackupPlanVersionsResponse> {
    private final BackupAsyncClient client;
    private final ListBackupPlanVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBackupPlanVersionsPublisher(BackupAsyncClient client, ListBackupPlanVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBackupPlanVersionsPublisher(BackupAsyncClient client, ListBackupPlanVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBackupPlanVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBackupPlanVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListBackupPlanVersionsResponseFetcher
    implements AsyncPageFetcher<ListBackupPlanVersionsResponse> {
        private ListBackupPlanVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListBackupPlanVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBackupPlanVersionsResponse> nextPage(ListBackupPlanVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListBackupPlanVersionsPublisher.this.client.listBackupPlanVersions(ListBackupPlanVersionsPublisher.this.firstRequest);
            }
            return ListBackupPlanVersionsPublisher.this.client.listBackupPlanVersions((ListBackupPlanVersionsRequest)((Object)ListBackupPlanVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

