/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.Framework;

final class FrameworkListCopier {
    FrameworkListCopier() {
    }

    static List<Framework> copy(Collection<? extends Framework> frameworkListParam) {
        Object list;
        if (frameworkListParam == null || frameworkListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            frameworkListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Framework> copyFromBuilder(Collection<? extends Framework.Builder> frameworkListParam) {
        Object list;
        if (frameworkListParam == null || frameworkListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            frameworkListParam.forEach(entry -> {
                Framework member = entry == null ? null : (Framework)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Framework.Builder> copyToBuilder(Collection<? extends Framework> frameworkListParam) {
        Object list;
        if (frameworkListParam == null || frameworkListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            frameworkListParam.forEach(entry -> {
                Framework.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

