/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutBackupVaultLockConfigurationRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, PutBackupVaultLockConfigurationRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(PutBackupVaultLockConfigurationRequest.getter(PutBackupVaultLockConfigurationRequest::backupVaultName)).setter(PutBackupVaultLockConfigurationRequest.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupVaultName").build()}).build();
    private static final SdkField<Long> MIN_RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MinRetentionDays").getter(PutBackupVaultLockConfigurationRequest.getter(PutBackupVaultLockConfigurationRequest::minRetentionDays)).setter(PutBackupVaultLockConfigurationRequest.setter(Builder::minRetentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinRetentionDays").build()}).build();
    private static final SdkField<Long> MAX_RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxRetentionDays").getter(PutBackupVaultLockConfigurationRequest.getter(PutBackupVaultLockConfigurationRequest::maxRetentionDays)).setter(PutBackupVaultLockConfigurationRequest.setter(Builder::maxRetentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetentionDays").build()}).build();
    private static final SdkField<Long> CHANGEABLE_FOR_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ChangeableForDays").getter(PutBackupVaultLockConfigurationRequest.getter(PutBackupVaultLockConfigurationRequest::changeableForDays)).setter(PutBackupVaultLockConfigurationRequest.setter(Builder::changeableForDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeableForDays").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD, MIN_RETENTION_DAYS_FIELD, MAX_RETENTION_DAYS_FIELD, CHANGEABLE_FOR_DAYS_FIELD));
    private final String backupVaultName;
    private final Long minRetentionDays;
    private final Long maxRetentionDays;
    private final Long changeableForDays;

    private PutBackupVaultLockConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.minRetentionDays = builder.minRetentionDays;
        this.maxRetentionDays = builder.maxRetentionDays;
        this.changeableForDays = builder.changeableForDays;
    }

    public final String backupVaultName() {
        return this.backupVaultName;
    }

    public final Long minRetentionDays() {
        return this.minRetentionDays;
    }

    public final Long maxRetentionDays() {
        return this.maxRetentionDays;
    }

    public final Long changeableForDays() {
        return this.changeableForDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.minRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeableForDays());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBackupVaultLockConfigurationRequest)) {
            return false;
        }
        PutBackupVaultLockConfigurationRequest other = (PutBackupVaultLockConfigurationRequest)((Object)obj);
        return Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.minRetentionDays(), other.minRetentionDays()) && Objects.equals(this.maxRetentionDays(), other.maxRetentionDays()) && Objects.equals(this.changeableForDays(), other.changeableForDays());
    }

    public final String toString() {
        return ToString.builder((String)"PutBackupVaultLockConfigurationRequest").add("BackupVaultName", (Object)this.backupVaultName()).add("MinRetentionDays", (Object)this.minRetentionDays()).add("MaxRetentionDays", (Object)this.maxRetentionDays()).add("ChangeableForDays", (Object)this.changeableForDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "MinRetentionDays": {
                return Optional.ofNullable(clazz.cast(this.minRetentionDays()));
            }
            case "MaxRetentionDays": {
                return Optional.ofNullable(clazz.cast(this.maxRetentionDays()));
            }
            case "ChangeableForDays": {
                return Optional.ofNullable(clazz.cast(this.changeableForDays()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutBackupVaultLockConfigurationRequest, T> g) {
        return obj -> g.apply((PutBackupVaultLockConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String backupVaultName;
        private Long minRetentionDays;
        private Long maxRetentionDays;
        private Long changeableForDays;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBackupVaultLockConfigurationRequest model) {
            super(model);
            this.backupVaultName(model.backupVaultName);
            this.minRetentionDays(model.minRetentionDays);
            this.maxRetentionDays(model.maxRetentionDays);
            this.changeableForDays(model.changeableForDays);
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        @Transient
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final Long getMinRetentionDays() {
            return this.minRetentionDays;
        }

        public final void setMinRetentionDays(Long minRetentionDays) {
            this.minRetentionDays = minRetentionDays;
        }

        @Override
        @Transient
        public final Builder minRetentionDays(Long minRetentionDays) {
            this.minRetentionDays = minRetentionDays;
            return this;
        }

        public final Long getMaxRetentionDays() {
            return this.maxRetentionDays;
        }

        public final void setMaxRetentionDays(Long maxRetentionDays) {
            this.maxRetentionDays = maxRetentionDays;
        }

        @Override
        @Transient
        public final Builder maxRetentionDays(Long maxRetentionDays) {
            this.maxRetentionDays = maxRetentionDays;
            return this;
        }

        public final Long getChangeableForDays() {
            return this.changeableForDays;
        }

        public final void setChangeableForDays(Long changeableForDays) {
            this.changeableForDays = changeableForDays;
        }

        @Override
        @Transient
        public final Builder changeableForDays(Long changeableForDays) {
            this.changeableForDays = changeableForDays;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBackupVaultLockConfigurationRequest build() {
            return new PutBackupVaultLockConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutBackupVaultLockConfigurationRequest> {
        public Builder backupVaultName(String var1);

        public Builder minRetentionDays(Long var1);

        public Builder maxRetentionDays(Long var1);

        public Builder changeableForDays(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

