/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.RestoreJobsListCopier;
import software.amazon.awssdk.services.backup.model.RestoreJobsListMember;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRestoreJobsResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListRestoreJobsResponse> {
    private static final SdkField<List<RestoreJobsListMember>> RESTORE_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RestoreJobs").getter(ListRestoreJobsResponse.getter(ListRestoreJobsResponse::restoreJobs)).setter(ListRestoreJobsResponse.setter(Builder::restoreJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RestoreJobsListMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRestoreJobsResponse.getter(ListRestoreJobsResponse::nextToken)).setter(ListRestoreJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTORE_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private final List<RestoreJobsListMember> restoreJobs;
    private final String nextToken;

    private ListRestoreJobsResponse(BuilderImpl builder) {
        super(builder);
        this.restoreJobs = builder.restoreJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRestoreJobs() {
        return this.restoreJobs != null && !(this.restoreJobs instanceof SdkAutoConstructList);
    }

    public final List<RestoreJobsListMember> restoreJobs() {
        return this.restoreJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRestoreJobs() ? this.restoreJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRestoreJobsResponse)) {
            return false;
        }
        ListRestoreJobsResponse other = (ListRestoreJobsResponse)((Object)obj);
        return this.hasRestoreJobs() == other.hasRestoreJobs() && Objects.equals(this.restoreJobs(), other.restoreJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRestoreJobsResponse").add("RestoreJobs", this.hasRestoreJobs() ? this.restoreJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RestoreJobs": {
                return Optional.ofNullable(clazz.cast(this.restoreJobs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRestoreJobsResponse, T> g) {
        return obj -> g.apply((ListRestoreJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private List<RestoreJobsListMember> restoreJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRestoreJobsResponse model) {
            super(model);
            this.restoreJobs(model.restoreJobs);
            this.nextToken(model.nextToken);
        }

        public final List<RestoreJobsListMember.Builder> getRestoreJobs() {
            List<RestoreJobsListMember.Builder> result = RestoreJobsListCopier.copyToBuilder(this.restoreJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRestoreJobs(Collection<RestoreJobsListMember.BuilderImpl> restoreJobs) {
            this.restoreJobs = RestoreJobsListCopier.copyFromBuilder(restoreJobs);
        }

        @Override
        @Transient
        public final Builder restoreJobs(Collection<RestoreJobsListMember> restoreJobs) {
            this.restoreJobs = RestoreJobsListCopier.copy(restoreJobs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder restoreJobs(RestoreJobsListMember ... restoreJobs) {
            this.restoreJobs(Arrays.asList(restoreJobs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder restoreJobs(Consumer<RestoreJobsListMember.Builder> ... restoreJobs) {
            this.restoreJobs(Stream.of(restoreJobs).map(c -> (RestoreJobsListMember)((RestoreJobsListMember.Builder)RestoreJobsListMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRestoreJobsResponse build() {
            return new ListRestoreJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRestoreJobsResponse> {
        public Builder restoreJobs(Collection<RestoreJobsListMember> var1);

        public Builder restoreJobs(RestoreJobsListMember ... var1);

        public Builder restoreJobs(Consumer<RestoreJobsListMember.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

