/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.Condition;
import software.amazon.awssdk.services.backup.model.Conditions;
import software.amazon.awssdk.services.backup.model.ListOfTagsCopier;
import software.amazon.awssdk.services.backup.model.ResourceArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackupSelection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackupSelection> {
    private static final SdkField<String> SELECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectionName").getter(BackupSelection.getter(BackupSelection::selectionName)).setter(BackupSelection.setter(Builder::selectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionName").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(BackupSelection.getter(BackupSelection::iamRoleArn)).setter(BackupSelection.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(BackupSelection.getter(BackupSelection::resources)).setter(BackupSelection.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Condition>> LIST_OF_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ListOfTags").getter(BackupSelection.getter(BackupSelection::listOfTags)).setter(BackupSelection.setter(Builder::listOfTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListOfTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Condition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotResources").getter(BackupSelection.getter(BackupSelection::notResources)).setter(BackupSelection.setter(Builder::notResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Conditions> CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Conditions").getter(BackupSelection.getter(BackupSelection::conditions)).setter(BackupSelection.setter(Builder::conditions)).constructor(Conditions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTION_NAME_FIELD, IAM_ROLE_ARN_FIELD, RESOURCES_FIELD, LIST_OF_TAGS_FIELD, NOT_RESOURCES_FIELD, CONDITIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String selectionName;
    private final String iamRoleArn;
    private final List<String> resources;
    private final List<Condition> listOfTags;
    private final List<String> notResources;
    private final Conditions conditions;

    private BackupSelection(BuilderImpl builder) {
        this.selectionName = builder.selectionName;
        this.iamRoleArn = builder.iamRoleArn;
        this.resources = builder.resources;
        this.listOfTags = builder.listOfTags;
        this.notResources = builder.notResources;
        this.conditions = builder.conditions;
    }

    public final String selectionName() {
        return this.selectionName;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<String> resources() {
        return this.resources;
    }

    public final boolean hasListOfTags() {
        return this.listOfTags != null && !(this.listOfTags instanceof SdkAutoConstructList);
    }

    public final List<Condition> listOfTags() {
        return this.listOfTags;
    }

    public final boolean hasNotResources() {
        return this.notResources != null && !(this.notResources instanceof SdkAutoConstructList);
    }

    public final List<String> notResources() {
        return this.notResources;
    }

    public final Conditions conditions() {
        return this.conditions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListOfTags() ? this.listOfTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotResources() ? this.notResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.conditions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupSelection)) {
            return false;
        }
        BackupSelection other = (BackupSelection)obj;
        return Objects.equals(this.selectionName(), other.selectionName()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && this.hasListOfTags() == other.hasListOfTags() && Objects.equals(this.listOfTags(), other.listOfTags()) && this.hasNotResources() == other.hasNotResources() && Objects.equals(this.notResources(), other.notResources()) && Objects.equals(this.conditions(), other.conditions());
    }

    public final String toString() {
        return ToString.builder((String)"BackupSelection").add("SelectionName", (Object)this.selectionName()).add("IamRoleArn", (Object)this.iamRoleArn()).add("Resources", this.hasResources() ? this.resources() : null).add("ListOfTags", this.hasListOfTags() ? this.listOfTags() : null).add("NotResources", this.hasNotResources() ? this.notResources() : null).add("Conditions", (Object)this.conditions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SelectionName": {
                return Optional.ofNullable(clazz.cast(this.selectionName()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "ListOfTags": {
                return Optional.ofNullable(clazz.cast(this.listOfTags()));
            }
            case "NotResources": {
                return Optional.ofNullable(clazz.cast(this.notResources()));
            }
            case "Conditions": {
                return Optional.ofNullable(clazz.cast(this.conditions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackupSelection, T> g) {
        return obj -> g.apply((BackupSelection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String selectionName;
        private String iamRoleArn;
        private List<String> resources = DefaultSdkAutoConstructList.getInstance();
        private List<Condition> listOfTags = DefaultSdkAutoConstructList.getInstance();
        private List<String> notResources = DefaultSdkAutoConstructList.getInstance();
        private Conditions conditions;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupSelection model) {
            this.selectionName(model.selectionName);
            this.iamRoleArn(model.iamRoleArn);
            this.resources(model.resources);
            this.listOfTags(model.listOfTags);
            this.notResources(model.notResources);
            this.conditions(model.conditions);
        }

        public final String getSelectionName() {
            return this.selectionName;
        }

        public final void setSelectionName(String selectionName) {
            this.selectionName = selectionName;
        }

        @Override
        @Transient
        public final Builder selectionName(String selectionName) {
            this.selectionName = selectionName;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        @Transient
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final Collection<String> getResources() {
            if (this.resources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resources;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = ResourceArnsCopier.copy(resources);
        }

        @Override
        @Transient
        public final Builder resources(Collection<String> resources) {
            this.resources = ResourceArnsCopier.copy(resources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resources(String ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        public final List<Condition.Builder> getListOfTags() {
            List<Condition.Builder> result = ListOfTagsCopier.copyToBuilder(this.listOfTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListOfTags(Collection<Condition.BuilderImpl> listOfTags) {
            this.listOfTags = ListOfTagsCopier.copyFromBuilder(listOfTags);
        }

        @Override
        @Transient
        public final Builder listOfTags(Collection<Condition> listOfTags) {
            this.listOfTags = ListOfTagsCopier.copy(listOfTags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder listOfTags(Condition ... listOfTags) {
            this.listOfTags(Arrays.asList(listOfTags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder listOfTags(Consumer<Condition.Builder> ... listOfTags) {
            this.listOfTags(Stream.of(listOfTags).map(c -> (Condition)((Condition.Builder)Condition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getNotResources() {
            if (this.notResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notResources;
        }

        public final void setNotResources(Collection<String> notResources) {
            this.notResources = ResourceArnsCopier.copy(notResources);
        }

        @Override
        @Transient
        public final Builder notResources(Collection<String> notResources) {
            this.notResources = ResourceArnsCopier.copy(notResources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notResources(String ... notResources) {
            this.notResources(Arrays.asList(notResources));
            return this;
        }

        public final Conditions.Builder getConditions() {
            return this.conditions != null ? this.conditions.toBuilder() : null;
        }

        public final void setConditions(Conditions.BuilderImpl conditions) {
            this.conditions = conditions != null ? conditions.build() : null;
        }

        @Override
        @Transient
        public final Builder conditions(Conditions conditions) {
            this.conditions = conditions;
            return this;
        }

        public BackupSelection build() {
            return new BackupSelection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackupSelection> {
        public Builder selectionName(String var1);

        public Builder iamRoleArn(String var1);

        public Builder resources(Collection<String> var1);

        public Builder resources(String ... var1);

        public Builder listOfTags(Collection<Condition> var1);

        public Builder listOfTags(Condition ... var1);

        public Builder listOfTags(Consumer<Condition.Builder> ... var1);

        public Builder notResources(Collection<String> var1);

        public Builder notResources(String ... var1);

        public Builder conditions(Conditions var1);

        default public Builder conditions(Consumer<Conditions.Builder> conditions) {
            return this.conditions((Conditions)((Conditions.Builder)Conditions.builder().applyMutation(conditions)).build());
        }
    }
}

