/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.MetadataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecoveryPointRestoreMetadataResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, GetRecoveryPointRestoreMetadataResponse> {
    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultArn").getter(GetRecoveryPointRestoreMetadataResponse.getter(GetRecoveryPointRestoreMetadataResponse::backupVaultArn)).setter(GetRecoveryPointRestoreMetadataResponse.setter(Builder::backupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()}).build();
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryPointArn").getter(GetRecoveryPointRestoreMetadataResponse.getter(GetRecoveryPointRestoreMetadataResponse::recoveryPointArn)).setter(GetRecoveryPointRestoreMetadataResponse.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()}).build();
    private static final SdkField<Map<String, String>> RESTORE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RestoreMetadata").getter(GetRecoveryPointRestoreMetadataResponse.getter(GetRecoveryPointRestoreMetadataResponse::restoreMetadata)).setter(GetRecoveryPointRestoreMetadataResponse.setter(Builder::restoreMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_ARN_FIELD, RECOVERY_POINT_ARN_FIELD, RESTORE_METADATA_FIELD));
    private final String backupVaultArn;
    private final String recoveryPointArn;
    private final Map<String, String> restoreMetadata;

    private GetRecoveryPointRestoreMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.backupVaultArn = builder.backupVaultArn;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.restoreMetadata = builder.restoreMetadata;
    }

    public String backupVaultArn() {
        return this.backupVaultArn;
    }

    public String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public boolean hasRestoreMetadata() {
        return this.restoreMetadata != null && !(this.restoreMetadata instanceof SdkAutoConstructMap);
    }

    public Map<String, String> restoreMetadata() {
        return this.restoreMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecoveryPointRestoreMetadataResponse)) {
            return false;
        }
        GetRecoveryPointRestoreMetadataResponse other = (GetRecoveryPointRestoreMetadataResponse)((Object)obj);
        return Objects.equals(this.backupVaultArn(), other.backupVaultArn()) && Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.restoreMetadata(), other.restoreMetadata());
    }

    public String toString() {
        return ToString.builder((String)"GetRecoveryPointRestoreMetadataResponse").add("BackupVaultArn", (Object)this.backupVaultArn()).add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("RestoreMetadata", (Object)(this.restoreMetadata() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.backupVaultArn()));
            }
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "RestoreMetadata": {
                return Optional.ofNullable(clazz.cast(this.restoreMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecoveryPointRestoreMetadataResponse, T> g) {
        return obj -> g.apply((GetRecoveryPointRestoreMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String backupVaultArn;
        private String recoveryPointArn;
        private Map<String, String> restoreMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecoveryPointRestoreMetadataResponse model) {
            super(model);
            this.backupVaultArn(model.backupVaultArn);
            this.recoveryPointArn(model.recoveryPointArn);
            this.restoreMetadata(model.restoreMetadata);
        }

        public final String getBackupVaultArn() {
            return this.backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        public final Map<String, String> getRestoreMetadata() {
            return this.restoreMetadata;
        }

        @Override
        public final Builder restoreMetadata(Map<String, String> restoreMetadata) {
            this.restoreMetadata = MetadataCopier.copy(restoreMetadata);
            return this;
        }

        public final void setRestoreMetadata(Map<String, String> restoreMetadata) {
            this.restoreMetadata = MetadataCopier.copy(restoreMetadata);
        }

        @Override
        public GetRecoveryPointRestoreMetadataResponse build() {
            return new GetRecoveryPointRestoreMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecoveryPointRestoreMetadataResponse> {
        public Builder backupVaultArn(String var1);

        public Builder recoveryPointArn(String var1);

        public Builder restoreMetadata(Map<String, String> var1);
    }
}

