/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupPlanTemplatesListCopier;
import software.amazon.awssdk.services.backup.model.BackupPlanTemplatesListMember;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBackupPlanTemplatesResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListBackupPlanTemplatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListBackupPlanTemplatesResponse.getter(ListBackupPlanTemplatesResponse::nextToken)).setter(ListBackupPlanTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<BackupPlanTemplatesListMember>> BACKUP_PLAN_TEMPLATES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListBackupPlanTemplatesResponse.getter(ListBackupPlanTemplatesResponse::backupPlanTemplatesList)).setter(ListBackupPlanTemplatesResponse.setter(Builder::backupPlanTemplatesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanTemplatesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BackupPlanTemplatesListMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, BACKUP_PLAN_TEMPLATES_LIST_FIELD));
    private final String nextToken;
    private final List<BackupPlanTemplatesListMember> backupPlanTemplatesList;

    private ListBackupPlanTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.backupPlanTemplatesList = builder.backupPlanTemplatesList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasBackupPlanTemplatesList() {
        return this.backupPlanTemplatesList != null && !(this.backupPlanTemplatesList instanceof SdkAutoConstructList);
    }

    public List<BackupPlanTemplatesListMember> backupPlanTemplatesList() {
        return this.backupPlanTemplatesList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanTemplatesList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupPlanTemplatesResponse)) {
            return false;
        }
        ListBackupPlanTemplatesResponse other = (ListBackupPlanTemplatesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.backupPlanTemplatesList(), other.backupPlanTemplatesList());
    }

    public String toString() {
        return ToString.builder((String)"ListBackupPlanTemplatesResponse").add("NextToken", (Object)this.nextToken()).add("BackupPlanTemplatesList", this.backupPlanTemplatesList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "BackupPlanTemplatesList": {
                return Optional.ofNullable(clazz.cast(this.backupPlanTemplatesList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBackupPlanTemplatesResponse, T> g) {
        return obj -> g.apply((ListBackupPlanTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<BackupPlanTemplatesListMember> backupPlanTemplatesList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupPlanTemplatesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.backupPlanTemplatesList(model.backupPlanTemplatesList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<BackupPlanTemplatesListMember.Builder> getBackupPlanTemplatesList() {
            return this.backupPlanTemplatesList != null ? (Collection)this.backupPlanTemplatesList.stream().map(BackupPlanTemplatesListMember::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder backupPlanTemplatesList(Collection<BackupPlanTemplatesListMember> backupPlanTemplatesList) {
            this.backupPlanTemplatesList = BackupPlanTemplatesListCopier.copy(backupPlanTemplatesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupPlanTemplatesList(BackupPlanTemplatesListMember ... backupPlanTemplatesList) {
            this.backupPlanTemplatesList(Arrays.asList(backupPlanTemplatesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupPlanTemplatesList(Consumer<BackupPlanTemplatesListMember.Builder> ... backupPlanTemplatesList) {
            this.backupPlanTemplatesList(Stream.of(backupPlanTemplatesList).map(c -> (BackupPlanTemplatesListMember)((BackupPlanTemplatesListMember.Builder)BackupPlanTemplatesListMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBackupPlanTemplatesList(Collection<BackupPlanTemplatesListMember.BuilderImpl> backupPlanTemplatesList) {
            this.backupPlanTemplatesList = BackupPlanTemplatesListCopier.copyFromBuilder(backupPlanTemplatesList);
        }

        @Override
        public ListBackupPlanTemplatesResponse build() {
            return new ListBackupPlanTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBackupPlanTemplatesResponse> {
        public Builder nextToken(String var1);

        public Builder backupPlanTemplatesList(Collection<BackupPlanTemplatesListMember> var1);

        public Builder backupPlanTemplatesList(BackupPlanTemplatesListMember ... var1);

        public Builder backupPlanTemplatesList(Consumer<BackupPlanTemplatesListMember.Builder> ... var1);
    }
}

