/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBackupSelectionResponse extends BackupResponse implements
        ToCopyableBuilder<GetBackupSelectionResponse.Builder, GetBackupSelectionResponse> {
    private static final SdkField<BackupSelection> BACKUP_SELECTION_FIELD = SdkField
            .<BackupSelection> builder(MarshallingType.SDK_POJO).getter(getter(GetBackupSelectionResponse::backupSelection))
            .setter(setter(Builder::backupSelection)).constructor(BackupSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSelection").build()).build();

    private static final SdkField<String> SELECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBackupSelectionResponse::selectionId)).setter(setter(Builder::selectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionId").build()).build();

    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBackupSelectionResponse::backupPlanId)).setter(setter(Builder::backupPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetBackupSelectionResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBackupSelectionResponse::creatorRequestId)).setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_SELECTION_FIELD,
            SELECTION_ID_FIELD, BACKUP_PLAN_ID_FIELD, CREATION_DATE_FIELD, CREATOR_REQUEST_ID_FIELD));

    private final BackupSelection backupSelection;

    private final String selectionId;

    private final String backupPlanId;

    private final Instant creationDate;

    private final String creatorRequestId;

    private GetBackupSelectionResponse(BuilderImpl builder) {
        super(builder);
        this.backupSelection = builder.backupSelection;
        this.selectionId = builder.selectionId;
        this.backupPlanId = builder.backupPlanId;
        this.creationDate = builder.creationDate;
        this.creatorRequestId = builder.creatorRequestId;
    }

    /**
     * <p>
     * Specifies the body of a request to assign a set of resources to a backup plan.
     * </p>
     * 
     * @return Specifies the body of a request to assign a set of resources to a backup plan.
     */
    public BackupSelection backupSelection() {
        return backupSelection;
    }

    /**
     * <p>
     * Uniquely identifies the body of a request to assign a set of resources to a backup plan.
     * </p>
     * 
     * @return Uniquely identifies the body of a request to assign a set of resources to a backup plan.
     */
    public String selectionId() {
        return selectionId;
    }

    /**
     * <p>
     * Uniquely identifies a backup plan.
     * </p>
     * 
     * @return Uniquely identifies a backup plan.
     */
    public String backupPlanId() {
        return backupPlanId;
    }

    /**
     * <p>
     * The date and time a backup selection is created, in Unix format and Coordinated Universal Time (UTC). The value
     * of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time a backup selection is created, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * A unique string that identifies the request and allows failed requests to be retried without the risk of
     * executing the operation twice.
     * </p>
     * 
     * @return A unique string that identifies the request and allows failed requests to be retried without the risk of
     *         executing the operation twice.
     */
    public String creatorRequestId() {
        return creatorRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupSelection());
        hashCode = 31 * hashCode + Objects.hashCode(selectionId());
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBackupSelectionResponse)) {
            return false;
        }
        GetBackupSelectionResponse other = (GetBackupSelectionResponse) obj;
        return Objects.equals(backupSelection(), other.backupSelection()) && Objects.equals(selectionId(), other.selectionId())
                && Objects.equals(backupPlanId(), other.backupPlanId()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(creatorRequestId(), other.creatorRequestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetBackupSelectionResponse").add("BackupSelection", backupSelection())
                .add("SelectionId", selectionId()).add("BackupPlanId", backupPlanId()).add("CreationDate", creationDate())
                .add("CreatorRequestId", creatorRequestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupSelection":
            return Optional.ofNullable(clazz.cast(backupSelection()));
        case "SelectionId":
            return Optional.ofNullable(clazz.cast(selectionId()));
        case "BackupPlanId":
            return Optional.ofNullable(clazz.cast(backupPlanId()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBackupSelectionResponse, T> g) {
        return obj -> g.apply((GetBackupSelectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBackupSelectionResponse> {
        /**
         * <p>
         * Specifies the body of a request to assign a set of resources to a backup plan.
         * </p>
         * 
         * @param backupSelection
         *        Specifies the body of a request to assign a set of resources to a backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupSelection(BackupSelection backupSelection);

        /**
         * <p>
         * Specifies the body of a request to assign a set of resources to a backup plan.
         * </p>
         * This is a convenience that creates an instance of the {@link BackupSelection.Builder} avoiding the need to
         * create one manually via {@link BackupSelection#builder()}.
         *
         * When the {@link Consumer} completes, {@link BackupSelection.Builder#build()} is called immediately and its
         * result is passed to {@link #backupSelection(BackupSelection)}.
         * 
         * @param backupSelection
         *        a consumer that will call methods on {@link BackupSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupSelection(BackupSelection)
         */
        default Builder backupSelection(Consumer<BackupSelection.Builder> backupSelection) {
            return backupSelection(BackupSelection.builder().applyMutation(backupSelection).build());
        }

        /**
         * <p>
         * Uniquely identifies the body of a request to assign a set of resources to a backup plan.
         * </p>
         * 
         * @param selectionId
         *        Uniquely identifies the body of a request to assign a set of resources to a backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionId(String selectionId);

        /**
         * <p>
         * Uniquely identifies a backup plan.
         * </p>
         * 
         * @param backupPlanId
         *        Uniquely identifies a backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanId(String backupPlanId);

        /**
         * <p>
         * The date and time a backup selection is created, in Unix format and Coordinated Universal Time (UTC). The
         * value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationDate
         *        The date and time a backup selection is created, in Unix format and Coordinated Universal Time (UTC).
         *        The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * A unique string that identifies the request and allows failed requests to be retried without the risk of
         * executing the operation twice.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string that identifies the request and allows failed requests to be retried without the risk
         *        of executing the operation twice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private BackupSelection backupSelection;

        private String selectionId;

        private String backupPlanId;

        private Instant creationDate;

        private String creatorRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBackupSelectionResponse model) {
            super(model);
            backupSelection(model.backupSelection);
            selectionId(model.selectionId);
            backupPlanId(model.backupPlanId);
            creationDate(model.creationDate);
            creatorRequestId(model.creatorRequestId);
        }

        public final BackupSelection.Builder getBackupSelection() {
            return backupSelection != null ? backupSelection.toBuilder() : null;
        }

        @Override
        public final Builder backupSelection(BackupSelection backupSelection) {
            this.backupSelection = backupSelection;
            return this;
        }

        public final void setBackupSelection(BackupSelection.BuilderImpl backupSelection) {
            this.backupSelection = backupSelection != null ? backupSelection.build() : null;
        }

        public final String getSelectionId() {
            return selectionId;
        }

        @Override
        public final Builder selectionId(String selectionId) {
            this.selectionId = selectionId;
            return this;
        }

        public final void setSelectionId(String selectionId) {
            this.selectionId = selectionId;
        }

        public final String getBackupPlanId() {
            return backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public GetBackupSelectionResponse build() {
            return new GetBackupSelectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
