/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportBackupPlanTemplateResponse extends BackupResponse implements
        ToCopyableBuilder<ExportBackupPlanTemplateResponse.Builder, ExportBackupPlanTemplateResponse> {
    private static final SdkField<String> BACKUP_PLAN_TEMPLATE_JSON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportBackupPlanTemplateResponse::backupPlanTemplateJson))
            .setter(setter(Builder::backupPlanTemplateJson))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanTemplateJson").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BACKUP_PLAN_TEMPLATE_JSON_FIELD));

    private final String backupPlanTemplateJson;

    private ExportBackupPlanTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.backupPlanTemplateJson = builder.backupPlanTemplateJson;
    }

    /**
     * <p>
     * The body of a backup plan template in JSON format.
     * </p>
     * <note>
     * <p>
     * This is a signed JSON document that cannot be modified before being passed to <code>GetBackupPlanFromJSON.</code>
     * </p>
     * </note>
     * 
     * @return The body of a backup plan template in JSON format.</p> <note>
     *         <p>
     *         This is a signed JSON document that cannot be modified before being passed to
     *         <code>GetBackupPlanFromJSON.</code>
     *         </p>
     */
    public String backupPlanTemplateJson() {
        return backupPlanTemplateJson;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanTemplateJson());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportBackupPlanTemplateResponse)) {
            return false;
        }
        ExportBackupPlanTemplateResponse other = (ExportBackupPlanTemplateResponse) obj;
        return Objects.equals(backupPlanTemplateJson(), other.backupPlanTemplateJson());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExportBackupPlanTemplateResponse").add("BackupPlanTemplateJson", backupPlanTemplateJson())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlanTemplateJson":
            return Optional.ofNullable(clazz.cast(backupPlanTemplateJson()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportBackupPlanTemplateResponse, T> g) {
        return obj -> g.apply((ExportBackupPlanTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, ExportBackupPlanTemplateResponse> {
        /**
         * <p>
         * The body of a backup plan template in JSON format.
         * </p>
         * <note>
         * <p>
         * This is a signed JSON document that cannot be modified before being passed to
         * <code>GetBackupPlanFromJSON.</code>
         * </p>
         * </note>
         * 
         * @param backupPlanTemplateJson
         *        The body of a backup plan template in JSON format.</p> <note>
         *        <p>
         *        This is a signed JSON document that cannot be modified before being passed to
         *        <code>GetBackupPlanFromJSON.</code>
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanTemplateJson(String backupPlanTemplateJson);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String backupPlanTemplateJson;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportBackupPlanTemplateResponse model) {
            super(model);
            backupPlanTemplateJson(model.backupPlanTemplateJson);
        }

        public final String getBackupPlanTemplateJson() {
            return backupPlanTemplateJson;
        }

        @Override
        public final Builder backupPlanTemplateJson(String backupPlanTemplateJson) {
            this.backupPlanTemplateJson = backupPlanTemplateJson;
            return this;
        }

        public final void setBackupPlanTemplateJson(String backupPlanTemplateJson) {
            this.backupPlanTemplateJson = backupPlanTemplateJson;
        }

        @Override
        public ExportBackupPlanTemplateResponse build() {
            return new ExportBackupPlanTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
