/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.model.ListCopyJobsRequest;
import software.amazon.awssdk.services.backup.model.ListCopyJobsResponse;

public class ListCopyJobsIterable
implements SdkIterable<ListCopyJobsResponse> {
    private final BackupClient client;
    private final ListCopyJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCopyJobsIterable(BackupClient client, ListCopyJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCopyJobsResponseFetcher();
    }

    public Iterator<ListCopyJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCopyJobsResponseFetcher
    implements SyncPageFetcher<ListCopyJobsResponse> {
        private ListCopyJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListCopyJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCopyJobsResponse nextPage(ListCopyJobsResponse previousPage) {
            if (previousPage == null) {
                return ListCopyJobsIterable.this.client.listCopyJobs(ListCopyJobsIterable.this.firstRequest);
            }
            return ListCopyJobsIterable.this.client.listCopyJobs((ListCopyJobsRequest)((Object)ListCopyJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

