/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupRule;
import software.amazon.awssdk.services.backup.model.BackupRulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackupPlan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackupPlan> {
    private static final SdkField<String> BACKUP_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupPlan.getter(BackupPlan::backupPlanName)).setter(BackupPlan.setter(Builder::backupPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanName").build()}).build();
    private static final SdkField<List<BackupRule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BackupPlan.getter(BackupPlan::rules)).setter(BackupPlan.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BackupRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_NAME_FIELD, RULES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String backupPlanName;
    private final List<BackupRule> rules;

    private BackupPlan(BuilderImpl builder) {
        this.backupPlanName = builder.backupPlanName;
        this.rules = builder.rules;
    }

    public String backupPlanName() {
        return this.backupPlanName;
    }

    public List<BackupRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupPlan)) {
            return false;
        }
        BackupPlan other = (BackupPlan)obj;
        return Objects.equals(this.backupPlanName(), other.backupPlanName()) && Objects.equals(this.rules(), other.rules());
    }

    public String toString() {
        return ToString.builder((String)"BackupPlan").add("BackupPlanName", (Object)this.backupPlanName()).add("Rules", this.rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupPlanName": {
                return Optional.ofNullable(clazz.cast(this.backupPlanName()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackupPlan, T> g) {
        return obj -> g.apply((BackupPlan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupPlanName;
        private List<BackupRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BackupPlan model) {
            this.backupPlanName(model.backupPlanName);
            this.rules(model.rules);
        }

        public final String getBackupPlanName() {
            return this.backupPlanName;
        }

        @Override
        public final Builder backupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
            return this;
        }

        public final void setBackupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
        }

        public final Collection<BackupRule.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(BackupRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<BackupRule> rules) {
            this.rules = BackupRulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(BackupRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<BackupRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (BackupRule)((BackupRule.Builder)BackupRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<BackupRule.BuilderImpl> rules) {
            this.rules = BackupRulesCopier.copyFromBuilder(rules);
        }

        public BackupPlan build() {
            return new BackupPlan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackupPlan> {
        public Builder backupPlanName(String var1);

        public Builder rules(Collection<BackupRule> var1);

        public Builder rules(BackupRule ... var1);

        public Builder rules(Consumer<BackupRule.Builder> ... var1);
    }
}

