/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackupSelectionsListMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackupSelectionsListMember> {
    private static final SdkField<String> SELECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupSelectionsListMember.getter(BackupSelectionsListMember::selectionId)).setter(BackupSelectionsListMember.setter(Builder::selectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionId").build()}).build();
    private static final SdkField<String> SELECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupSelectionsListMember.getter(BackupSelectionsListMember::selectionName)).setter(BackupSelectionsListMember.setter(Builder::selectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionName").build()}).build();
    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupSelectionsListMember.getter(BackupSelectionsListMember::backupPlanId)).setter(BackupSelectionsListMember.setter(Builder::backupPlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanId").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(BackupSelectionsListMember.getter(BackupSelectionsListMember::creationDate)).setter(BackupSelectionsListMember.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupSelectionsListMember.getter(BackupSelectionsListMember::creatorRequestId)).setter(BackupSelectionsListMember.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupSelectionsListMember.getter(BackupSelectionsListMember::iamRoleArn)).setter(BackupSelectionsListMember.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTION_ID_FIELD, SELECTION_NAME_FIELD, BACKUP_PLAN_ID_FIELD, CREATION_DATE_FIELD, CREATOR_REQUEST_ID_FIELD, IAM_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String selectionId;
    private final String selectionName;
    private final String backupPlanId;
    private final Instant creationDate;
    private final String creatorRequestId;
    private final String iamRoleArn;

    private BackupSelectionsListMember(BuilderImpl builder) {
        this.selectionId = builder.selectionId;
        this.selectionName = builder.selectionName;
        this.backupPlanId = builder.backupPlanId;
        this.creationDate = builder.creationDate;
        this.creatorRequestId = builder.creatorRequestId;
        this.iamRoleArn = builder.iamRoleArn;
    }

    public String selectionId() {
        return this.selectionId;
    }

    public String selectionName() {
        return this.selectionName;
    }

    public String backupPlanId() {
        return this.backupPlanId;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public String creatorRequestId() {
        return this.creatorRequestId;
    }

    public String iamRoleArn() {
        return this.iamRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupSelectionsListMember)) {
            return false;
        }
        BackupSelectionsListMember other = (BackupSelectionsListMember)obj;
        return Objects.equals(this.selectionId(), other.selectionId()) && Objects.equals(this.selectionName(), other.selectionName()) && Objects.equals(this.backupPlanId(), other.backupPlanId()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn());
    }

    public String toString() {
        return ToString.builder((String)"BackupSelectionsListMember").add("SelectionId", (Object)this.selectionId()).add("SelectionName", (Object)this.selectionName()).add("BackupPlanId", (Object)this.backupPlanId()).add("CreationDate", (Object)this.creationDate()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("IamRoleArn", (Object)this.iamRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SelectionId": {
                return Optional.ofNullable(clazz.cast(this.selectionId()));
            }
            case "SelectionName": {
                return Optional.ofNullable(clazz.cast(this.selectionName()));
            }
            case "BackupPlanId": {
                return Optional.ofNullable(clazz.cast(this.backupPlanId()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackupSelectionsListMember, T> g) {
        return obj -> g.apply((BackupSelectionsListMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String selectionId;
        private String selectionName;
        private String backupPlanId;
        private Instant creationDate;
        private String creatorRequestId;
        private String iamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupSelectionsListMember model) {
            this.selectionId(model.selectionId);
            this.selectionName(model.selectionName);
            this.backupPlanId(model.backupPlanId);
            this.creationDate(model.creationDate);
            this.creatorRequestId(model.creatorRequestId);
            this.iamRoleArn(model.iamRoleArn);
        }

        public final String getSelectionId() {
            return this.selectionId;
        }

        @Override
        public final Builder selectionId(String selectionId) {
            this.selectionId = selectionId;
            return this;
        }

        public final void setSelectionId(String selectionId) {
            this.selectionId = selectionId;
        }

        public final String getSelectionName() {
            return this.selectionName;
        }

        @Override
        public final Builder selectionName(String selectionName) {
            this.selectionName = selectionName;
            return this;
        }

        public final void setSelectionName(String selectionName) {
            this.selectionName = selectionName;
        }

        public final String getBackupPlanId() {
            return this.backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public BackupSelectionsListMember build() {
            return new BackupSelectionsListMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackupSelectionsListMember> {
        public Builder selectionId(String var1);

        public Builder selectionName(String var1);

        public Builder backupPlanId(String var1);

        public Builder creationDate(Instant var1);

        public Builder creatorRequestId(String var1);

        public Builder iamRoleArn(String var1);
    }
}

