/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the X12 transaction set and version. The X12 structure is used when the system transforms
 * an EDI (electronic data interchange) file.
 * </p>
 * <note>
 * <p>
 * If an EDI input file contains more than one transaction, each transaction must have the same transaction set and
 * version, for example 214/4010. If not, the transformer cannot parse the file.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class X12Details implements SdkPojo, Serializable, ToCopyableBuilder<X12Details.Builder, X12Details> {
    private static final SdkField<String> TRANSACTION_SET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transactionSet").getter(getter(X12Details::transactionSetAsString))
            .setter(setter(Builder::transactionSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionSet").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(X12Details::versionAsString)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_SET_FIELD,
            VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String transactionSet;

    private final String version;

    private X12Details(BuilderImpl builder) {
        this.transactionSet = builder.transactionSet;
        this.version = builder.version;
    }

    /**
     * <p>
     * Returns an enumerated type where each value identifies an X12 transaction set. Transaction sets are maintained by
     * the X12 Accredited Standards Committee.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transactionSet}
     * will return {@link X12TransactionSet#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #transactionSetAsString}.
     * </p>
     * 
     * @return Returns an enumerated type where each value identifies an X12 transaction set. Transaction sets are
     *         maintained by the X12 Accredited Standards Committee.
     * @see X12TransactionSet
     */
    public final X12TransactionSet transactionSet() {
        return X12TransactionSet.fromValue(transactionSet);
    }

    /**
     * <p>
     * Returns an enumerated type where each value identifies an X12 transaction set. Transaction sets are maintained by
     * the X12 Accredited Standards Committee.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transactionSet}
     * will return {@link X12TransactionSet#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #transactionSetAsString}.
     * </p>
     * 
     * @return Returns an enumerated type where each value identifies an X12 transaction set. Transaction sets are
     *         maintained by the X12 Accredited Standards Committee.
     * @see X12TransactionSet
     */
    public final String transactionSetAsString() {
        return transactionSet;
    }

    /**
     * <p>
     * Returns the version to use for the specified X12 transaction set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #version} will
     * return {@link X12Version#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #versionAsString}.
     * </p>
     * 
     * @return Returns the version to use for the specified X12 transaction set.
     * @see X12Version
     */
    public final X12Version version() {
        return X12Version.fromValue(version);
    }

    /**
     * <p>
     * Returns the version to use for the specified X12 transaction set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #version} will
     * return {@link X12Version#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #versionAsString}.
     * </p>
     * 
     * @return Returns the version to use for the specified X12 transaction set.
     * @see X12Version
     */
    public final String versionAsString() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transactionSetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(versionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12Details)) {
            return false;
        }
        X12Details other = (X12Details) obj;
        return Objects.equals(transactionSetAsString(), other.transactionSetAsString())
                && Objects.equals(versionAsString(), other.versionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("X12Details").add("TransactionSet", transactionSetAsString()).add("Version", versionAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transactionSet":
            return Optional.ofNullable(clazz.cast(transactionSetAsString()));
        case "version":
            return Optional.ofNullable(clazz.cast(versionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("transactionSet", TRANSACTION_SET_FIELD);
        map.put("version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<X12Details, T> g) {
        return obj -> g.apply((X12Details) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, X12Details> {
        /**
         * <p>
         * Returns an enumerated type where each value identifies an X12 transaction set. Transaction sets are
         * maintained by the X12 Accredited Standards Committee.
         * </p>
         * 
         * @param transactionSet
         *        Returns an enumerated type where each value identifies an X12 transaction set. Transaction sets are
         *        maintained by the X12 Accredited Standards Committee.
         * @see X12TransactionSet
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see X12TransactionSet
         */
        Builder transactionSet(String transactionSet);

        /**
         * <p>
         * Returns an enumerated type where each value identifies an X12 transaction set. Transaction sets are
         * maintained by the X12 Accredited Standards Committee.
         * </p>
         * 
         * @param transactionSet
         *        Returns an enumerated type where each value identifies an X12 transaction set. Transaction sets are
         *        maintained by the X12 Accredited Standards Committee.
         * @see X12TransactionSet
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see X12TransactionSet
         */
        Builder transactionSet(X12TransactionSet transactionSet);

        /**
         * <p>
         * Returns the version to use for the specified X12 transaction set.
         * </p>
         * 
         * @param version
         *        Returns the version to use for the specified X12 transaction set.
         * @see X12Version
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see X12Version
         */
        Builder version(String version);

        /**
         * <p>
         * Returns the version to use for the specified X12 transaction set.
         * </p>
         * 
         * @param version
         *        Returns the version to use for the specified X12 transaction set.
         * @see X12Version
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see X12Version
         */
        Builder version(X12Version version);
    }

    static final class BuilderImpl implements Builder {
        private String transactionSet;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(X12Details model) {
            transactionSet(model.transactionSet);
            version(model.version);
        }

        public final String getTransactionSet() {
            return transactionSet;
        }

        public final void setTransactionSet(String transactionSet) {
            this.transactionSet = transactionSet;
        }

        @Override
        public final Builder transactionSet(String transactionSet) {
            this.transactionSet = transactionSet;
            return this;
        }

        @Override
        public final Builder transactionSet(X12TransactionSet transactionSet) {
            this.transactionSet(transactionSet == null ? null : transactionSet.toString());
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public final Builder version(X12Version version) {
            this.version(version == null ? null : version.toString());
            return this;
        }

        @Override
        public X12Details build() {
            return new X12Details(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
