/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCapabilityRequest extends B2BiRequest implements
        ToCopyableBuilder<UpdateCapabilityRequest.Builder, UpdateCapabilityRequest> {
    private static final SdkField<String> CAPABILITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("capabilityId").getter(getter(UpdateCapabilityRequest::capabilityId))
            .setter(setter(Builder::capabilityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateCapabilityRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<CapabilityConfiguration> CONFIGURATION_FIELD = SdkField
            .<CapabilityConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(UpdateCapabilityRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(CapabilityConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<List<S3Location>> INSTRUCTIONS_DOCUMENTS_FIELD = SdkField
            .<List<S3Location>> builder(MarshallingType.LIST)
            .memberName("instructionsDocuments")
            .getter(getter(UpdateCapabilityRequest::instructionsDocuments))
            .setter(setter(Builder::instructionsDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instructionsDocuments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3Location::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPABILITY_ID_FIELD,
            NAME_FIELD, CONFIGURATION_FIELD, INSTRUCTIONS_DOCUMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String capabilityId;

    private final String name;

    private final CapabilityConfiguration configuration;

    private final List<S3Location> instructionsDocuments;

    private UpdateCapabilityRequest(BuilderImpl builder) {
        super(builder);
        this.capabilityId = builder.capabilityId;
        this.name = builder.name;
        this.configuration = builder.configuration;
        this.instructionsDocuments = builder.instructionsDocuments;
    }

    /**
     * <p>
     * Specifies a system-assigned unique identifier for the capability.
     * </p>
     * 
     * @return Specifies a system-assigned unique identifier for the capability.
     */
    public final String capabilityId() {
        return capabilityId;
    }

    /**
     * <p>
     * Specifies a new name for the capability, to replace the existing name.
     * </p>
     * 
     * @return Specifies a new name for the capability, to replace the existing name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies a structure that contains the details for a capability.
     * </p>
     * 
     * @return Specifies a structure that contains the details for a capability.
     */
    public final CapabilityConfiguration configuration() {
        return configuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstructionsDocuments property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInstructionsDocuments() {
        return instructionsDocuments != null && !(instructionsDocuments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies one or more locations in Amazon S3, each specifying an EDI document that can be used with this
     * capability. Each item contains the name of the bucket and the key, to identify the document's location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstructionsDocuments} method.
     * </p>
     * 
     * @return Specifies one or more locations in Amazon S3, each specifying an EDI document that can be used with this
     *         capability. Each item contains the name of the bucket and the key, to identify the document's location.
     */
    public final List<S3Location> instructionsDocuments() {
        return instructionsDocuments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capabilityId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstructionsDocuments() ? instructionsDocuments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCapabilityRequest)) {
            return false;
        }
        UpdateCapabilityRequest other = (UpdateCapabilityRequest) obj;
        return Objects.equals(capabilityId(), other.capabilityId()) && Objects.equals(name(), other.name())
                && Objects.equals(configuration(), other.configuration())
                && hasInstructionsDocuments() == other.hasInstructionsDocuments()
                && Objects.equals(instructionsDocuments(), other.instructionsDocuments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCapabilityRequest").add("CapabilityId", capabilityId()).add("Name", name())
                .add("Configuration", configuration())
                .add("InstructionsDocuments", hasInstructionsDocuments() ? instructionsDocuments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capabilityId":
            return Optional.ofNullable(clazz.cast(capabilityId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "instructionsDocuments":
            return Optional.ofNullable(clazz.cast(instructionsDocuments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("capabilityId", CAPABILITY_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("instructionsDocuments", INSTRUCTIONS_DOCUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCapabilityRequest, T> g) {
        return obj -> g.apply((UpdateCapabilityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends B2BiRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCapabilityRequest> {
        /**
         * <p>
         * Specifies a system-assigned unique identifier for the capability.
         * </p>
         * 
         * @param capabilityId
         *        Specifies a system-assigned unique identifier for the capability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityId(String capabilityId);

        /**
         * <p>
         * Specifies a new name for the capability, to replace the existing name.
         * </p>
         * 
         * @param name
         *        Specifies a new name for the capability, to replace the existing name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies a structure that contains the details for a capability.
         * </p>
         * 
         * @param configuration
         *        Specifies a structure that contains the details for a capability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(CapabilityConfiguration configuration);

        /**
         * <p>
         * Specifies a structure that contains the details for a capability.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapabilityConfiguration.Builder} avoiding
         * the need to create one manually via {@link CapabilityConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapabilityConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(CapabilityConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link CapabilityConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(CapabilityConfiguration)
         */
        default Builder configuration(Consumer<CapabilityConfiguration.Builder> configuration) {
            return configuration(CapabilityConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Specifies one or more locations in Amazon S3, each specifying an EDI document that can be used with this
         * capability. Each item contains the name of the bucket and the key, to identify the document's location.
         * </p>
         * 
         * @param instructionsDocuments
         *        Specifies one or more locations in Amazon S3, each specifying an EDI document that can be used with
         *        this capability. Each item contains the name of the bucket and the key, to identify the document's
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instructionsDocuments(Collection<S3Location> instructionsDocuments);

        /**
         * <p>
         * Specifies one or more locations in Amazon S3, each specifying an EDI document that can be used with this
         * capability. Each item contains the name of the bucket and the key, to identify the document's location.
         * </p>
         * 
         * @param instructionsDocuments
         *        Specifies one or more locations in Amazon S3, each specifying an EDI document that can be used with
         *        this capability. Each item contains the name of the bucket and the key, to identify the document's
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instructionsDocuments(S3Location... instructionsDocuments);

        /**
         * <p>
         * Specifies one or more locations in Amazon S3, each specifying an EDI document that can be used with this
         * capability. Each item contains the name of the bucket and the key, to identify the document's location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.b2bi.model.S3Location.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.b2bi.model.S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.b2bi.model.S3Location.Builder#build()} is called immediately and its
         * result is passed to {@link #instructionsDocuments(List<S3Location>)}.
         * 
         * @param instructionsDocuments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.b2bi.model.S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instructionsDocuments(java.util.Collection<S3Location>)
         */
        Builder instructionsDocuments(Consumer<S3Location.Builder>... instructionsDocuments);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends B2BiRequest.BuilderImpl implements Builder {
        private String capabilityId;

        private String name;

        private CapabilityConfiguration configuration;

        private List<S3Location> instructionsDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCapabilityRequest model) {
            super(model);
            capabilityId(model.capabilityId);
            name(model.name);
            configuration(model.configuration);
            instructionsDocuments(model.instructionsDocuments);
        }

        public final String getCapabilityId() {
            return capabilityId;
        }

        public final void setCapabilityId(String capabilityId) {
            this.capabilityId = capabilityId;
        }

        @Override
        public final Builder capabilityId(String capabilityId) {
            this.capabilityId = capabilityId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CapabilityConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(CapabilityConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(CapabilityConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final List<S3Location.Builder> getInstructionsDocuments() {
            List<S3Location.Builder> result = InstructionsDocumentsCopier.copyToBuilder(this.instructionsDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstructionsDocuments(Collection<S3Location.BuilderImpl> instructionsDocuments) {
            this.instructionsDocuments = InstructionsDocumentsCopier.copyFromBuilder(instructionsDocuments);
        }

        @Override
        public final Builder instructionsDocuments(Collection<S3Location> instructionsDocuments) {
            this.instructionsDocuments = InstructionsDocumentsCopier.copy(instructionsDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instructionsDocuments(S3Location... instructionsDocuments) {
            instructionsDocuments(Arrays.asList(instructionsDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instructionsDocuments(Consumer<S3Location.Builder>... instructionsDocuments) {
            instructionsDocuments(Stream.of(instructionsDocuments).map(c -> S3Location.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCapabilityRequest build() {
            return new UpdateCapabilityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
