/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.X12SplitOptions;
import software.amazon.awssdk.services.b2bi.model.X12ValidationOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class X12AdvancedOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, X12AdvancedOptions> {
    private static final SdkField<X12SplitOptions> SPLIT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("splitOptions").getter(X12AdvancedOptions.getter(X12AdvancedOptions::splitOptions)).setter(X12AdvancedOptions.setter(Builder::splitOptions)).constructor(X12SplitOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("splitOptions").build()}).build();
    private static final SdkField<X12ValidationOptions> VALIDATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("validationOptions").getter(X12AdvancedOptions.getter(X12AdvancedOptions::validationOptions)).setter(X12AdvancedOptions.setter(Builder::validationOptions)).constructor(X12ValidationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPLIT_OPTIONS_FIELD, VALIDATION_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = X12AdvancedOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final X12SplitOptions splitOptions;
    private final X12ValidationOptions validationOptions;

    private X12AdvancedOptions(BuilderImpl builder) {
        this.splitOptions = builder.splitOptions;
        this.validationOptions = builder.validationOptions;
    }

    public final X12SplitOptions splitOptions() {
        return this.splitOptions;
    }

    public final X12ValidationOptions validationOptions() {
        return this.validationOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.splitOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12AdvancedOptions)) {
            return false;
        }
        X12AdvancedOptions other = (X12AdvancedOptions)obj;
        return Objects.equals(this.splitOptions(), other.splitOptions()) && Objects.equals(this.validationOptions(), other.validationOptions());
    }

    public final String toString() {
        return ToString.builder((String)"X12AdvancedOptions").add("SplitOptions", (Object)this.splitOptions()).add("ValidationOptions", (Object)this.validationOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "splitOptions": {
                return Optional.ofNullable(clazz.cast(this.splitOptions()));
            }
            case "validationOptions": {
                return Optional.ofNullable(clazz.cast(this.validationOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("splitOptions", SPLIT_OPTIONS_FIELD);
        map.put("validationOptions", VALIDATION_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<X12AdvancedOptions, T> g) {
        return obj -> g.apply((X12AdvancedOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private X12SplitOptions splitOptions;
        private X12ValidationOptions validationOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(X12AdvancedOptions model) {
            this.splitOptions(model.splitOptions);
            this.validationOptions(model.validationOptions);
        }

        public final X12SplitOptions.Builder getSplitOptions() {
            return this.splitOptions != null ? this.splitOptions.toBuilder() : null;
        }

        public final void setSplitOptions(X12SplitOptions.BuilderImpl splitOptions) {
            this.splitOptions = splitOptions != null ? splitOptions.build() : null;
        }

        @Override
        public final Builder splitOptions(X12SplitOptions splitOptions) {
            this.splitOptions = splitOptions;
            return this;
        }

        public final X12ValidationOptions.Builder getValidationOptions() {
            return this.validationOptions != null ? this.validationOptions.toBuilder() : null;
        }

        public final void setValidationOptions(X12ValidationOptions.BuilderImpl validationOptions) {
            this.validationOptions = validationOptions != null ? validationOptions.build() : null;
        }

        @Override
        public final Builder validationOptions(X12ValidationOptions validationOptions) {
            this.validationOptions = validationOptions;
            return this;
        }

        public X12AdvancedOptions build() {
            return new X12AdvancedOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, X12AdvancedOptions> {
        public Builder splitOptions(X12SplitOptions var1);

        default public Builder splitOptions(Consumer<X12SplitOptions.Builder> splitOptions) {
            return this.splitOptions((X12SplitOptions)((X12SplitOptions.Builder)X12SplitOptions.builder().applyMutation(splitOptions)).build());
        }

        public Builder validationOptions(X12ValidationOptions var1);

        default public Builder validationOptions(Consumer<X12ValidationOptions.Builder> validationOptions) {
            return this.validationOptions((X12ValidationOptions)((X12ValidationOptions.Builder)X12ValidationOptions.builder().applyMutation(validationOptions)).build());
        }
    }
}

