/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.b2bi.B2BiAsyncClient;
import software.amazon.awssdk.services.b2bi.internal.UserAgentUtils;
import software.amazon.awssdk.services.b2bi.model.ListPartnershipsRequest;
import software.amazon.awssdk.services.b2bi.model.ListPartnershipsResponse;
import software.amazon.awssdk.services.b2bi.model.PartnershipSummary;

public class ListPartnershipsPublisher
implements SdkPublisher<ListPartnershipsResponse> {
    private final B2BiAsyncClient client;
    private final ListPartnershipsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPartnershipsPublisher(B2BiAsyncClient client, ListPartnershipsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPartnershipsPublisher(B2BiAsyncClient client, ListPartnershipsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPartnershipsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPartnershipsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PartnershipSummary> partnerships() {
        Function<ListPartnershipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.partnerships() != null) {
                return response.partnerships().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPartnershipsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPartnershipsResponseFetcher
    implements AsyncPageFetcher<ListPartnershipsResponse> {
        private ListPartnershipsResponseFetcher() {
        }

        public boolean hasNextPage(ListPartnershipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPartnershipsResponse> nextPage(ListPartnershipsResponse previousPage) {
            if (previousPage == null) {
                return ListPartnershipsPublisher.this.client.listPartnerships(ListPartnershipsPublisher.this.firstRequest);
            }
            return ListPartnershipsPublisher.this.client.listPartnerships((ListPartnershipsRequest)((Object)ListPartnershipsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

