/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.B2BiRequest;
import software.amazon.awssdk.services.b2bi.model.EdiType;
import software.amazon.awssdk.services.b2bi.model.FileFormat;
import software.amazon.awssdk.services.b2bi.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestParsingRequest
extends B2BiRequest
implements ToCopyableBuilder<Builder, TestParsingRequest> {
    private static final SdkField<S3Location> INPUT_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputFile").getter(TestParsingRequest.getter(TestParsingRequest::inputFile)).setter(TestParsingRequest.setter(Builder::inputFile)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputFile").build()}).build();
    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileFormat").getter(TestParsingRequest.getter(TestParsingRequest::fileFormatAsString)).setter(TestParsingRequest.setter(Builder::fileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()}).build();
    private static final SdkField<EdiType> EDI_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ediType").getter(TestParsingRequest.getter(TestParsingRequest::ediType)).setter(TestParsingRequest.setter(Builder::ediType)).constructor(EdiType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ediType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FILE_FIELD, FILE_FORMAT_FIELD, EDI_TYPE_FIELD));
    private final S3Location inputFile;
    private final String fileFormat;
    private final EdiType ediType;

    private TestParsingRequest(BuilderImpl builder) {
        super(builder);
        this.inputFile = builder.inputFile;
        this.fileFormat = builder.fileFormat;
        this.ediType = builder.ediType;
    }

    public final S3Location inputFile() {
        return this.inputFile;
    }

    public final FileFormat fileFormat() {
        return FileFormat.fromValue(this.fileFormat);
    }

    public final String fileFormatAsString() {
        return this.fileFormat;
    }

    public final EdiType ediType() {
        return this.ediType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ediType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestParsingRequest)) {
            return false;
        }
        TestParsingRequest other = (TestParsingRequest)((Object)obj);
        return Objects.equals(this.inputFile(), other.inputFile()) && Objects.equals(this.fileFormatAsString(), other.fileFormatAsString()) && Objects.equals(this.ediType(), other.ediType());
    }

    public final String toString() {
        return ToString.builder((String)"TestParsingRequest").add("InputFile", (Object)this.inputFile()).add("FileFormat", (Object)this.fileFormatAsString()).add("EdiType", (Object)this.ediType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputFile": {
                return Optional.ofNullable(clazz.cast(this.inputFile()));
            }
            case "fileFormat": {
                return Optional.ofNullable(clazz.cast(this.fileFormatAsString()));
            }
            case "ediType": {
                return Optional.ofNullable(clazz.cast(this.ediType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestParsingRequest, T> g) {
        return obj -> g.apply((TestParsingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiRequest.BuilderImpl
    implements Builder {
        private S3Location inputFile;
        private String fileFormat;
        private EdiType ediType;

        private BuilderImpl() {
        }

        private BuilderImpl(TestParsingRequest model) {
            super(model);
            this.inputFile(model.inputFile);
            this.fileFormat(model.fileFormat);
            this.ediType(model.ediType);
        }

        public final S3Location.Builder getInputFile() {
            return this.inputFile != null ? this.inputFile.toBuilder() : null;
        }

        public final void setInputFile(S3Location.BuilderImpl inputFile) {
            this.inputFile = inputFile != null ? inputFile.build() : null;
        }

        @Override
        public final Builder inputFile(S3Location inputFile) {
            this.inputFile = inputFile;
            return this;
        }

        public final String getFileFormat() {
            return this.fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(FileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final EdiType.Builder getEdiType() {
            return this.ediType != null ? this.ediType.toBuilder() : null;
        }

        public final void setEdiType(EdiType.BuilderImpl ediType) {
            this.ediType = ediType != null ? ediType.build() : null;
        }

        @Override
        public final Builder ediType(EdiType ediType) {
            this.ediType = ediType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestParsingRequest build() {
            return new TestParsingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends B2BiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestParsingRequest> {
        public Builder inputFile(S3Location var1);

        default public Builder inputFile(Consumer<S3Location.Builder> inputFile) {
            return this.inputFile((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(inputFile)).build());
        }

        public Builder fileFormat(String var1);

        public Builder fileFormat(FileFormat var1);

        public Builder ediType(EdiType var1);

        default public Builder ediType(Consumer<EdiType.Builder> ediType) {
            return this.ediType((EdiType)((EdiType.Builder)EdiType.builder().applyMutation(ediType)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

