/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.b2bi.model.CapabilityOptions;
import software.amazon.awssdk.services.b2bi.model.PartnershipCapabilitiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PartnershipSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PartnershipSummary> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileId").getter(PartnershipSummary.getter(PartnershipSummary::profileId)).setter(PartnershipSummary.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileId").build()}).build();
    private static final SdkField<String> PARTNERSHIP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("partnershipId").getter(PartnershipSummary.getter(PartnershipSummary::partnershipId)).setter(PartnershipSummary.setter(Builder::partnershipId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partnershipId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(PartnershipSummary.getter(PartnershipSummary::name)).setter(PartnershipSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capabilities").getter(PartnershipSummary.getter(PartnershipSummary::capabilities)).setter(PartnershipSummary.setter(Builder::capabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CapabilityOptions> CAPABILITY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("capabilityOptions").getter(PartnershipSummary.getter(PartnershipSummary::capabilityOptions)).setter(PartnershipSummary.setter(Builder::capabilityOptions)).constructor(CapabilityOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityOptions").build()}).build();
    private static final SdkField<String> TRADING_PARTNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tradingPartnerId").getter(PartnershipSummary.getter(PartnershipSummary::tradingPartnerId)).setter(PartnershipSummary.setter(Builder::tradingPartnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tradingPartnerId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(PartnershipSummary.getter(PartnershipSummary::createdAt)).setter(PartnershipSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(PartnershipSummary.getter(PartnershipSummary::modifiedAt)).setter(PartnershipSummary.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD, PARTNERSHIP_ID_FIELD, NAME_FIELD, CAPABILITIES_FIELD, CAPABILITY_OPTIONS_FIELD, TRADING_PARTNER_ID_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String profileId;
    private final String partnershipId;
    private final String name;
    private final List<String> capabilities;
    private final CapabilityOptions capabilityOptions;
    private final String tradingPartnerId;
    private final Instant createdAt;
    private final Instant modifiedAt;

    private PartnershipSummary(BuilderImpl builder) {
        this.profileId = builder.profileId;
        this.partnershipId = builder.partnershipId;
        this.name = builder.name;
        this.capabilities = builder.capabilities;
        this.capabilityOptions = builder.capabilityOptions;
        this.tradingPartnerId = builder.tradingPartnerId;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final String partnershipId() {
        return this.partnershipId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<String> capabilities() {
        return this.capabilities;
    }

    public final CapabilityOptions capabilityOptions() {
        return this.capabilityOptions;
    }

    public final String tradingPartnerId() {
        return this.tradingPartnerId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnershipId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.tradingPartnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartnershipSummary)) {
            return false;
        }
        PartnershipSummary other = (PartnershipSummary)obj;
        return Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.partnershipId(), other.partnershipId()) && Objects.equals(this.name(), other.name()) && this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilities(), other.capabilities()) && Objects.equals(this.capabilityOptions(), other.capabilityOptions()) && Objects.equals(this.tradingPartnerId(), other.tradingPartnerId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt());
    }

    public final String toString() {
        return ToString.builder((String)"PartnershipSummary").add("ProfileId", (Object)this.profileId()).add("PartnershipId", (Object)this.partnershipId()).add("Name", (Object)this.name()).add("Capabilities", this.hasCapabilities() ? this.capabilities() : null).add("CapabilityOptions", (Object)this.capabilityOptions()).add("TradingPartnerId", (Object)this.tradingPartnerId()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "profileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "partnershipId": {
                return Optional.ofNullable(clazz.cast(this.partnershipId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
            case "capabilityOptions": {
                return Optional.ofNullable(clazz.cast(this.capabilityOptions()));
            }
            case "tradingPartnerId": {
                return Optional.ofNullable(clazz.cast(this.tradingPartnerId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PartnershipSummary, T> g) {
        return obj -> g.apply((PartnershipSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String profileId;
        private String partnershipId;
        private String name;
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private CapabilityOptions capabilityOptions;
        private String tradingPartnerId;
        private Instant createdAt;
        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(PartnershipSummary model) {
            this.profileId(model.profileId);
            this.partnershipId(model.partnershipId);
            this.name(model.name);
            this.capabilities(model.capabilities);
            this.capabilityOptions(model.capabilityOptions);
            this.tradingPartnerId(model.tradingPartnerId);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getPartnershipId() {
            return this.partnershipId;
        }

        public final void setPartnershipId(String partnershipId) {
            this.partnershipId = partnershipId;
        }

        @Override
        public final Builder partnershipId(String partnershipId) {
            this.partnershipId = partnershipId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (this.capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = PartnershipCapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = PartnershipCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final CapabilityOptions.Builder getCapabilityOptions() {
            return this.capabilityOptions != null ? this.capabilityOptions.toBuilder() : null;
        }

        public final void setCapabilityOptions(CapabilityOptions.BuilderImpl capabilityOptions) {
            this.capabilityOptions = capabilityOptions != null ? capabilityOptions.build() : null;
        }

        @Override
        public final Builder capabilityOptions(CapabilityOptions capabilityOptions) {
            this.capabilityOptions = capabilityOptions;
            return this;
        }

        public final String getTradingPartnerId() {
            return this.tradingPartnerId;
        }

        public final void setTradingPartnerId(String tradingPartnerId) {
            this.tradingPartnerId = tradingPartnerId;
        }

        @Override
        public final Builder tradingPartnerId(String tradingPartnerId) {
            this.tradingPartnerId = tradingPartnerId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public PartnershipSummary build() {
            return new PartnershipSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PartnershipSummary> {
        public Builder profileId(String var1);

        public Builder partnershipId(String var1);

        public Builder name(String var1);

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder capabilityOptions(CapabilityOptions var1);

        default public Builder capabilityOptions(Consumer<CapabilityOptions.Builder> capabilityOptions) {
            return this.capabilityOptions((CapabilityOptions)((CapabilityOptions.Builder)CapabilityOptions.builder().applyMutation(capabilityOptions)).build());
        }

        public Builder tradingPartnerId(String var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);
    }
}

