/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.query.unmarshall;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.unmarshall.XmlDomParser;
import software.amazon.awssdk.protocols.query.unmarshall.XmlElement;
import software.amazon.awssdk.protocols.query.unmarshall.XmlErrorUnmarshaller;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.Pair;

@SdkProtectedApi
public final class AwsXmlErrorProtocolUnmarshaller
implements HttpResponseHandler<AwsServiceException> {
    private final List<ExceptionMetadata> exceptions;
    private final Supplier<SdkPojo> defaultExceptionSupplier;
    private final Function<XmlElement, Optional<XmlElement>> errorRootExtractor;
    private final XmlErrorUnmarshaller errorUnmarshaller;

    private AwsXmlErrorProtocolUnmarshaller(Builder builder) {
        this.exceptions = builder.exceptions;
        this.errorRootExtractor = builder.errorRootExtractor;
        this.errorUnmarshaller = builder.errorUnmarshaller;
        this.defaultExceptionSupplier = builder.defaultExceptionSupplier;
    }

    public AwsServiceException handle(SdkHttpFullResponse response, ExecutionAttributes executionAttributes) {
        Pair<XmlElement, SdkBytes> xmlAndBytes = this.parseXml(response);
        XmlElement document = (XmlElement)xmlAndBytes.left();
        Optional<XmlElement> errorRoot = this.errorRootExtractor.apply(document);
        String errorCode = this.getErrorCode(errorRoot);
        AwsServiceException.Builder builder = errorRoot.map(e -> (AwsServiceException.Builder)FunctionalUtils.invokeSafely(() -> this.unmarshallFromErrorCode(response, (XmlElement)e, errorCode))).orElseGet(this::defaultException);
        AwsErrorDetails awsErrorDetails = AwsErrorDetails.builder().errorCode(errorCode).errorMessage(builder.message()).rawResponse((SdkBytes)xmlAndBytes.right()).sdkHttpResponse((SdkHttpResponse)response).serviceName((String)executionAttributes.getAttribute(AwsExecutionAttribute.SERVICE_NAME)).build();
        builder.requestId(this.getRequestId(response, document)).statusCode(response.statusCode()).clockSkew(this.getClockSkew(executionAttributes)).awsErrorDetails(awsErrorDetails);
        return builder.build();
    }

    private Duration getClockSkew(ExecutionAttributes executionAttributes) {
        Integer timeOffset = (Integer)executionAttributes.getAttribute(SdkExecutionAttribute.TIME_OFFSET);
        return timeOffset == null ? null : Duration.ofSeconds(timeOffset.intValue());
    }

    private Pair<XmlElement, SdkBytes> parseXml(SdkHttpFullResponse response) {
        SdkBytes bytes = this.getResponseBytes(response);
        try {
            return Pair.of((Object)XmlDomParser.parse(bytes.asInputStream()), (Object)bytes);
        }
        catch (Exception e) {
            return Pair.of((Object)XmlElement.empty(), (Object)bytes);
        }
    }

    private SdkBytes getResponseBytes(SdkHttpFullResponse response) {
        try {
            return response.content().map(SdkBytes::fromInputStream).orElseGet(this::emptyXmlBytes);
        }
        catch (Exception e) {
            return this.emptyXmlBytes();
        }
    }

    private SdkBytes emptyXmlBytes() {
        return SdkBytes.fromUtf8String((String)"<eof/>");
    }

    private AwsServiceException.Builder defaultException() {
        return (AwsServiceException.Builder)this.defaultExceptionSupplier.get();
    }

    private AwsServiceException.Builder unmarshallFromErrorCode(SdkHttpFullResponse response, XmlElement errorRoot, String errorCode) {
        SdkPojo sdkPojo = this.exceptions.stream().filter(e -> e.errorCode().equals(errorCode)).map(ExceptionMetadata::exceptionBuilderSupplier).findAny().orElse(this.defaultExceptionSupplier).get();
        AwsServiceException.Builder builder = ((AwsServiceException)this.errorUnmarshaller.unmarshall(sdkPojo, errorRoot, response)).toBuilder();
        builder.message(this.getMessage(errorRoot));
        return builder;
    }

    private String getErrorCode(Optional<XmlElement> errorRoot) {
        return errorRoot.map(e -> e.getOptionalElementByName("Code").map(XmlElement::textContent).orElse(null)).orElse(null);
    }

    private String getMessage(XmlElement errorRoot) {
        return errorRoot.getOptionalElementByName("Message").map(XmlElement::textContent).orElse(null);
    }

    private String getRequestId(SdkHttpFullResponse response, XmlElement document) {
        XmlElement requestId = document.getOptionalElementByName("RequestId").orElse(document.getElementByName("RequestID"));
        return requestId != null ? requestId.textContent() : (String)response.firstMatchingHeader("x-amzn-RequestId").orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ExceptionMetadata> exceptions;
        private Supplier<SdkPojo> defaultExceptionSupplier;
        private Function<XmlElement, Optional<XmlElement>> errorRootExtractor;
        private XmlErrorUnmarshaller errorUnmarshaller;

        private Builder() {
        }

        public Builder exceptions(List<ExceptionMetadata> exceptions) {
            this.exceptions = exceptions;
            return this;
        }

        public Builder defaultExceptionSupplier(Supplier<SdkPojo> defaultExceptionSupplier) {
            this.defaultExceptionSupplier = defaultExceptionSupplier;
            return this;
        }

        public Builder errorRootExtractor(Function<XmlElement, Optional<XmlElement>> errorRootExtractor) {
            this.errorRootExtractor = errorRootExtractor;
            return this;
        }

        public Builder errorUnmarshaller(XmlErrorUnmarshaller errorUnmarshaller) {
            this.errorUnmarshaller = errorUnmarshaller;
            return this;
        }

        public AwsXmlErrorProtocolUnmarshaller build() {
            return new AwsXmlErrorProtocolUnmarshaller(this);
        }
    }
}

