/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal;

import java.time.Duration;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.io.TlsCipherPreference;
import software.amazon.awssdk.http.crt.AwsCrtAsyncHttpClient;
import software.amazon.awssdk.http.crt.TcpKeepAliveConfiguration;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.NumericUtils;

@SdkInternalApi
public final class AwsCrtConfigurationUtils {
    private static final Logger log = Logger.loggerFor(AwsCrtAsyncHttpClient.class);

    private AwsCrtConfigurationUtils() {
    }

    public static SocketOptions buildSocketOptions(TcpKeepAliveConfiguration tcpKeepAliveConfiguration, Duration connectionTimeout) {
        SocketOptions clientSocketOptions = new SocketOptions();
        if (connectionTimeout != null) {
            clientSocketOptions.connectTimeoutMs = NumericUtils.saturatedCast((long)connectionTimeout.toMillis());
        }
        if (tcpKeepAliveConfiguration != null) {
            clientSocketOptions.keepAlive = true;
            clientSocketOptions.keepAliveIntervalSecs = NumericUtils.saturatedCast((long)tcpKeepAliveConfiguration.keepAliveInterval().getSeconds());
            clientSocketOptions.keepAliveTimeoutSecs = NumericUtils.saturatedCast((long)tcpKeepAliveConfiguration.keepAliveTimeout().getSeconds());
        }
        return clientSocketOptions;
    }

    public static TlsCipherPreference resolveCipherPreference(Boolean postQuantumTlsEnabled) {
        TlsCipherPreference defaultTls = TlsCipherPreference.TLS_CIPHER_SYSTEM_DEFAULT;
        if (postQuantumTlsEnabled == null || !postQuantumTlsEnabled.booleanValue()) {
            return defaultTls;
        }
        TlsCipherPreference pqTls = TlsCipherPreference.TLS_CIPHER_PQ_DEFAULT;
        if (!pqTls.isSupported()) {
            log.warn(() -> "Hybrid post-quantum cipher suites are not supported on this platform. The SDK will use the system default cipher suites instead");
            return defaultTls;
        }
        return pqTls;
    }
}

