/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.utils.ByteBufferUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class AwsCrtRequestBodySubscriber
implements Subscriber<ByteBuffer> {
    private static final Logger log = Logger.loggerFor(AwsCrtRequestBodySubscriber.class);
    private final int windowSize;
    private final Queue<ByteBuffer> queuedBuffers = new ConcurrentLinkedQueue<ByteBuffer>();
    private final AtomicLong queuedByteCount = new AtomicLong(0L);
    private final AtomicBoolean isComplete = new AtomicBoolean(false);
    private final AtomicReference<Throwable> error = new AtomicReference<Object>(null);
    private AtomicReference<Subscription> subscriptionRef = new AtomicReference<Object>(null);

    public AwsCrtRequestBodySubscriber(int windowSize) {
        Validate.isPositive((int)windowSize, (String)"windowSize is <= 0");
        this.windowSize = windowSize;
    }

    protected void requestDataIfNecessary() {
        Subscription subscription = this.subscriptionRef.get();
        if (subscription == null) {
            log.error(() -> "Subscription is null");
            return;
        }
        if (this.queuedByteCount.get() < (long)this.windowSize) {
            subscription.request(1L);
        }
    }

    public void onSubscribe(Subscription s) {
        Validate.paramNotNull((Object)s, (String)"s");
        boolean wasFirstSubscription = this.subscriptionRef.compareAndSet(null, s);
        if (!wasFirstSubscription) {
            log.error(() -> "Only one Subscription supported!");
            s.cancel();
            return;
        }
        this.requestDataIfNecessary();
    }

    public void onNext(ByteBuffer byteBuffer) {
        Validate.paramNotNull((Object)byteBuffer, (String)"byteBuffer");
        this.queuedBuffers.add(byteBuffer);
        this.queuedByteCount.addAndGet(byteBuffer.remaining());
        this.requestDataIfNecessary();
    }

    public void onError(Throwable t) {
        log.error(() -> "onError() received an error: " + t.getMessage());
        this.error.compareAndSet(null, t);
    }

    public void onComplete() {
        log.debug(() -> "AwsCrtRequestBodySubscriber Completed");
        this.isComplete.set(true);
    }

    public synchronized boolean transferRequestBody(ByteBuffer out) {
        boolean endOfStream;
        if (this.error.get() != null) {
            throw new RuntimeException(this.error.get());
        }
        while (out.remaining() > 0 && !this.queuedBuffers.isEmpty()) {
            ByteBuffer nextBuffer = this.queuedBuffers.peek();
            int amtTransferred = ByteBufferUtils.transferData((ByteBuffer)nextBuffer, (ByteBuffer)out);
            this.queuedByteCount.addAndGet(-amtTransferred);
            if (nextBuffer.remaining() != 0) continue;
            this.queuedBuffers.remove();
        }
        boolean bl = endOfStream = this.isComplete.get() && this.queuedBuffers.isEmpty();
        if (!endOfStream) {
            this.requestDataIfNecessary();
        } else {
            log.debug(() -> "End Of RequestBody reached");
        }
        return endOfStream;
    }
}

