/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt;

import java.net.URI;
import java.time.Duration;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.http.HttpClientConnectionManager;
import software.amazon.awssdk.crt.http.HttpClientConnectionManagerOptions;
import software.amazon.awssdk.crt.http.HttpMonitoringOptions;
import software.amazon.awssdk.crt.http.HttpProxyOptions;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.io.TlsCipherPreference;
import software.amazon.awssdk.crt.io.TlsContext;
import software.amazon.awssdk.crt.io.TlsContextOptions;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.crt.ConnectionHealthChecksConfiguration;
import software.amazon.awssdk.http.crt.ProxyConfiguration;
import software.amazon.awssdk.http.crt.internal.CrtRequestContext;
import software.amazon.awssdk.http.crt.internal.CrtRequestExecutor;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@SdkPreviewApi
public final class AwsCrtAsyncHttpClient
implements SdkAsyncHttpClient {
    private static final software.amazon.awssdk.utils.Logger log = software.amazon.awssdk.utils.Logger.loggerFor(AwsCrtAsyncHttpClient.class);
    private static final String AWS_COMMON_RUNTIME = "AwsCommonRuntime";
    private static final int DEFAULT_STREAM_WINDOW_SIZE = 0x1000000;
    private final Map<URI, HttpClientConnectionManager> connectionPools = new ConcurrentHashMap<URI, HttpClientConnectionManager>();
    private final LinkedList<CrtResource> ownedSubResources = new LinkedList();
    private final ClientBootstrap bootstrap;
    private final SocketOptions socketOptions;
    private final TlsContext tlsContext;
    private final HttpProxyOptions proxyOptions;
    private final HttpMonitoringOptions monitoringOptions;
    private final long maxConnectionIdleInMilliseconds;
    private final int readBufferSize;
    private final int maxConnectionsPerEndpoint;
    private boolean isClosed = false;

    private AwsCrtAsyncHttpClient(DefaultBuilder builder, AttributeMap config) {
        int maxConns = (Integer)config.get((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS);
        Validate.isPositive((int)maxConns, (String)"maxConns");
        Validate.notNull((Object)builder.cipherPreference, (String)"cipherPreference", (Object[])new Object[0]);
        Validate.isPositive((int)builder.readBufferSize, (String)"readBufferSize");
        try (ClientBootstrap clientBootstrap = new ClientBootstrap(null, null);
             SocketOptions clientSocketOptions = new SocketOptions();
             TlsContextOptions clientTlsContextOptions = TlsContextOptions.createDefaultClient().withCipherPreference(builder.cipherPreference).withVerifyPeer((Boolean)config.get((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES) == false);
             TlsContext clientTlsContext = new TlsContext(clientTlsContextOptions);){
            this.bootstrap = this.registerOwnedResource(clientBootstrap);
            this.socketOptions = this.registerOwnedResource(clientSocketOptions);
            this.tlsContext = this.registerOwnedResource(clientTlsContext);
            this.readBufferSize = builder.readBufferSize;
            this.maxConnectionsPerEndpoint = maxConns;
            this.monitoringOptions = this.revolveHttpMonitoringOptions(builder.connectionHealthChecksConfiguration);
            this.maxConnectionIdleInMilliseconds = ((Duration)config.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_MAX_IDLE_TIMEOUT)).toMillis();
            this.proxyOptions = this.buildProxyOptions(builder.proxyConfiguration);
        }
    }

    private HttpMonitoringOptions revolveHttpMonitoringOptions(ConnectionHealthChecksConfiguration config) {
        if (config == null) {
            return null;
        }
        HttpMonitoringOptions httpMonitoringOptions = new HttpMonitoringOptions();
        httpMonitoringOptions.setMinThroughputBytesPerSecond(config.minThroughputInBytesPerSecond());
        int seconds = (int)config.allowableThroughputFailureInterval().getSeconds();
        httpMonitoringOptions.setAllowableThroughputFailureIntervalSeconds(seconds);
        return httpMonitoringOptions;
    }

    private HttpProxyOptions buildProxyOptions(ProxyConfiguration proxyConfiguration) {
        if (proxyConfiguration == null) {
            return null;
        }
        HttpProxyOptions clientProxyOptions = new HttpProxyOptions();
        clientProxyOptions.setHost(proxyConfiguration.host());
        clientProxyOptions.setPort(proxyConfiguration.port());
        if ("https".equalsIgnoreCase(proxyConfiguration.scheme())) {
            clientProxyOptions.setTlsContext(this.tlsContext);
        }
        if (proxyConfiguration.username() != null && proxyConfiguration.password() != null) {
            clientProxyOptions.setAuthorizationUsername(proxyConfiguration.username());
            clientProxyOptions.setAuthorizationPassword(proxyConfiguration.password());
            clientProxyOptions.setAuthorizationType(HttpProxyOptions.HttpProxyAuthorizationType.Basic);
        } else {
            clientProxyOptions.setAuthorizationType(HttpProxyOptions.HttpProxyAuthorizationType.None);
        }
        return clientProxyOptions;
    }

    private <T extends CrtResource> T registerOwnedResource(T subresource) {
        if (subresource != null) {
            subresource.addRef();
            this.ownedSubResources.push(subresource);
        }
        return subresource;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static SdkAsyncHttpClient create() {
        return new DefaultBuilder().build();
    }

    public String clientName() {
        return AWS_COMMON_RUNTIME;
    }

    private HttpClientConnectionManager createConnectionPool(URI uri) {
        log.debug(() -> "Creating ConnectionPool for: URI:" + uri + ", MaxConns: " + this.maxConnectionsPerEndpoint);
        HttpClientConnectionManagerOptions options = new HttpClientConnectionManagerOptions().withClientBootstrap(this.bootstrap).withSocketOptions(this.socketOptions).withTlsContext(this.tlsContext).withUri(uri).withWindowSize(this.readBufferSize).withMaxConnections(this.maxConnectionsPerEndpoint).withManualWindowManagement(true).withProxyOptions(this.proxyOptions).withMonitoringOptions(this.monitoringOptions).withMaxConnectionIdleInMilliseconds(this.maxConnectionIdleInMilliseconds);
        return HttpClientConnectionManager.create((HttpClientConnectionManagerOptions)options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClientConnectionManager getOrCreateConnectionPool(URI uri) {
        AwsCrtAsyncHttpClient awsCrtAsyncHttpClient = this;
        synchronized (awsCrtAsyncHttpClient) {
            if (this.isClosed) {
                throw new IllegalStateException("Client is closed. No more requests can be made with this client.");
            }
            HttpClientConnectionManager connPool = this.connectionPools.computeIfAbsent(uri, this::createConnectionPool);
            connPool.addRef();
            return connPool;
        }
    }

    public CompletableFuture<Void> execute(AsyncExecuteRequest asyncRequest) {
        Validate.paramNotNull((Object)asyncRequest, (String)"asyncRequest");
        Validate.paramNotNull((Object)asyncRequest.request(), (String)"SdkHttpRequest");
        Validate.paramNotNull((Object)asyncRequest.requestContentPublisher(), (String)"RequestContentPublisher");
        Validate.paramNotNull((Object)asyncRequest.responseHandler(), (String)"ResponseHandler");
        try (HttpClientConnectionManager crtConnPool = this.getOrCreateConnectionPool(asyncRequest.request().getUri());){
            CrtRequestContext context = CrtRequestContext.builder().crtConnPool(crtConnPool).readBufferSize(this.readBufferSize).request(asyncRequest).build();
            CompletableFuture<Void> completableFuture = new CrtRequestExecutor().execute(context);
            return completableFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AwsCrtAsyncHttpClient awsCrtAsyncHttpClient = this;
        synchronized (awsCrtAsyncHttpClient) {
            if (this.isClosed) {
                return;
            }
            this.connectionPools.values().forEach(pool -> IoUtils.closeQuietly((AutoCloseable)pool, (Logger)log.logger()));
            this.ownedSubResources.forEach(r -> IoUtils.closeQuietly((AutoCloseable)r, (Logger)log.logger()));
            this.ownedSubResources.clear();
            this.isClosed = true;
        }
    }

    private static final class DefaultBuilder
    implements Builder {
        private final AttributeMap.Builder standardOptions = AttributeMap.builder();
        private TlsCipherPreference cipherPreference = TlsCipherPreference.TLS_CIPHER_SYSTEM_DEFAULT;
        private int readBufferSize = 0x1000000;
        private ProxyConfiguration proxyConfiguration;
        private ConnectionHealthChecksConfiguration connectionHealthChecksConfiguration;

        private DefaultBuilder() {
        }

        public SdkAsyncHttpClient build() {
            return new AwsCrtAsyncHttpClient(this, this.standardOptions.build().merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS));
        }

        public SdkAsyncHttpClient buildWithDefaults(AttributeMap serviceDefaults) {
            return new AwsCrtAsyncHttpClient(this, this.standardOptions.build().merge(serviceDefaults).merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS));
        }

        @Override
        public Builder maxConcurrency(int maxConcurrency) {
            Validate.isPositive((int)maxConcurrency, (String)"maxConcurrency");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS, (Object)maxConcurrency);
            return this;
        }

        @Override
        public Builder tlsCipherPreference(TlsCipherPreference tlsCipherPreference) {
            Validate.notNull((Object)tlsCipherPreference, (String)"cipherPreference", (Object[])new Object[0]);
            Validate.isTrue((boolean)TlsContextOptions.isCipherPreferenceSupported((TlsCipherPreference)tlsCipherPreference), (String)"TlsCipherPreference not supported on current Platform", (Object[])new Object[0]);
            this.cipherPreference = tlsCipherPreference;
            return this;
        }

        @Override
        public Builder readBufferSize(int readBufferSize) {
            Validate.isPositive((int)readBufferSize, (String)"readBufferSize");
            this.readBufferSize = readBufferSize;
            return this;
        }

        @Override
        public Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        @Override
        public Builder connectionHealthChecksConfiguration(ConnectionHealthChecksConfiguration monitoringOptions) {
            this.connectionHealthChecksConfiguration = monitoringOptions;
            return this;
        }

        @Override
        public Builder connectionHealthChecksConfiguration(Consumer<ConnectionHealthChecksConfiguration.Builder> configurationBuilder) {
            ConnectionHealthChecksConfiguration.Builder builder = ConnectionHealthChecksConfiguration.builder();
            configurationBuilder.accept(builder);
            return this.connectionHealthChecksConfiguration(builder.build());
        }

        @Override
        public Builder connectionMaxIdleTime(Duration connectionMaxIdleTime) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_MAX_IDLE_TIMEOUT, (Object)connectionMaxIdleTime);
            return this;
        }

        @Override
        public Builder proxyConfiguration(Consumer<ProxyConfiguration.Builder> proxyConfigurationBuilderConsumer) {
            ProxyConfiguration.Builder builder = ProxyConfiguration.builder();
            proxyConfigurationBuilderConsumer.accept(builder);
            return this.proxyConfiguration((ProxyConfiguration)builder.build());
        }
    }

    public static interface Builder
    extends SdkAsyncHttpClient.Builder<Builder> {
        public Builder maxConcurrency(int var1);

        public Builder tlsCipherPreference(TlsCipherPreference var1);

        public Builder readBufferSize(int var1);

        public Builder proxyConfiguration(ProxyConfiguration var1);

        public Builder proxyConfiguration(Consumer<ProxyConfiguration.Builder> var1);

        public Builder connectionHealthChecksConfiguration(ConnectionHealthChecksConfiguration var1);

        public Builder connectionHealthChecksConfiguration(Consumer<ConnectionHealthChecksConfiguration.Builder> var1);

        public Builder connectionMaxIdleTime(Duration var1);
    }
}

