/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.HttpClientConnection;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandler;
import software.amazon.awssdk.http.SdkCancellationException;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.http.crt.internal.AwsCrtAsyncHttpStreamAdapter;
import software.amazon.awssdk.http.crt.internal.CrtRequestContext;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkInternalApi
public final class CrtRequestExecutor {
    private static final Logger log = Logger.loggerFor(CrtRequestExecutor.class);

    public CompletableFuture<Void> execute(CrtRequestContext executionContext) {
        CompletableFuture<Void> requestFuture = this.createExecutionFuture(executionContext.sdkRequest());
        CompletableFuture httpClientConnectionCompletableFuture = executionContext.crtConnPool().acquireConnection();
        httpClientConnectionCompletableFuture.whenComplete((crtConn, throwable) -> {
            AsyncExecuteRequest asyncRequest = executionContext.sdkRequest();
            if (throwable != null) {
                this.handleFailure(new IOException("An exception occurred when acquiring connection", (Throwable)throwable), requestFuture, asyncRequest.responseHandler());
                return;
            }
            AwsCrtAsyncHttpStreamAdapter crtToSdkAdapter = new AwsCrtAsyncHttpStreamAdapter((HttpClientConnection)crtConn, requestFuture, asyncRequest, executionContext.readBufferSize());
            HttpRequest crtRequest = CrtRequestExecutor.toCrtRequest(asyncRequest, crtToSdkAdapter);
            FunctionalUtils.invokeSafely(() -> {
                try {
                    crtConn.makeRequest(crtRequest, (HttpStreamResponseHandler)crtToSdkAdapter).activate();
                }
                catch (IllegalStateException | CrtRuntimeException e) {
                    log.debug(() -> "An exception occurred when making the request", e);
                    this.handleFailure(new IOException("An exception occurred when making the request", e), requestFuture, asyncRequest.responseHandler());
                }
            });
        });
        return requestFuture;
    }

    private CompletableFuture<Void> createExecutionFuture(AsyncExecuteRequest request) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        future.whenComplete((r, t) -> {
            if (t == null) {
                return;
            }
            if (future.isCancelled()) {
                request.responseHandler().onError((Throwable)new SdkCancellationException("The request was cancelled"));
            }
        });
        return future;
    }

    private void handleFailure(Throwable cause, CompletableFuture<Void> executeFuture, SdkAsyncHttpResponseHandler responseHandler) {
        try {
            responseHandler.onError(cause);
        }
        catch (Exception e) {
            log.error(() -> String.format("SdkAsyncHttpResponseHandler %s throw an exception in onError", responseHandler.toString()), (Throwable)e);
        }
        executeFuture.completeExceptionally(cause);
    }

    private static HttpRequest toCrtRequest(AsyncExecuteRequest asyncRequest, AwsCrtAsyncHttpStreamAdapter crtToSdkAdapter) {
        URI uri = asyncRequest.request().getUri();
        SdkHttpRequest sdkRequest = asyncRequest.request();
        String method = sdkRequest.method().name();
        String encodedPath = sdkRequest.encodedPath();
        if (encodedPath == null || encodedPath.length() == 0) {
            encodedPath = "/";
        }
        String encodedQueryString = SdkHttpUtils.encodeAndFlattenQueryParameters((Map)sdkRequest.rawQueryParameters()).map(value -> "?" + value).orElse("");
        HttpHeader[] crtHeaderArray = CrtRequestExecutor.asArray(CrtRequestExecutor.createHttpHeaderList(uri, asyncRequest));
        return new HttpRequest(method, encodedPath + encodedQueryString, crtHeaderArray, (HttpRequestBodyStream)crtToSdkAdapter);
    }

    private static HttpHeader[] asArray(List<HttpHeader> crtHeaderList) {
        return crtHeaderList.toArray(new HttpHeader[0]);
    }

    private static List<HttpHeader> createHttpHeaderList(URI uri, AsyncExecuteRequest asyncRequest) {
        SdkHttpRequest sdkRequest = asyncRequest.request();
        ArrayList<HttpHeader> crtHeaderList = new ArrayList<HttpHeader>(sdkRequest.headers().size() + 3);
        if (CollectionUtils.isNullOrEmpty((Collection)((Collection)sdkRequest.headers().get("Host")))) {
            crtHeaderList.add(new HttpHeader("Host", uri.getHost()));
        }
        if (CollectionUtils.isNullOrEmpty((Collection)((Collection)sdkRequest.headers().get("Connection")))) {
            crtHeaderList.add(new HttpHeader("Connection", "keep-alive"));
        }
        Optional contentLength = asyncRequest.requestContentPublisher().contentLength();
        if (CollectionUtils.isNullOrEmpty((Collection)((Collection)sdkRequest.headers().get("Content-Length"))) && contentLength.isPresent()) {
            crtHeaderList.add(new HttpHeader("Content-Length", Long.toString((Long)contentLength.get())));
        }
        sdkRequest.headers().forEach((key, value) -> value.stream().map(val -> new HttpHeader(key, val)).forEach(crtHeaderList::add));
        return crtHeaderList;
    }
}

