/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.cbor.internal;

import java.io.IOException;
import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.protocols.json.SdkJsonGenerator;
import software.amazon.awssdk.protocols.json.StructuredJsonGenerator;
import software.amazon.awssdk.thirdparty.jackson.core.JsonFactory;
import software.amazon.awssdk.thirdparty.jackson.dataformat.cbor.CBORGenerator;

@SdkInternalApi
public final class SdkCborGenerator
extends SdkJsonGenerator {
    private static final int CBOR_TAG_TIMESTAMP = 1;

    SdkCborGenerator(JsonFactory factory, String contentType) {
        super(factory, contentType);
    }

    public StructuredJsonGenerator writeValue(Instant instant) {
        if (!(this.getGenerator() instanceof CBORGenerator)) {
            throw new IllegalStateException("SdkCborGenerator is not created with a CBORGenerator.");
        }
        CBORGenerator generator = (CBORGenerator)this.getGenerator();
        try {
            generator.writeTag(1);
            generator.writeNumber(instant.toEpochMilli());
        }
        catch (IOException e) {
            throw new SdkJsonGenerator.JsonGenerationException((Throwable)e);
        }
        return this;
    }
}

