/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.cbor;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.protocols.cbor.internal.AwsStructuredCborFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.DefaultJsonContentTypeResolver;
import software.amazon.awssdk.protocols.json.JsonContentTypeResolver;
import software.amazon.awssdk.protocols.json.StructuredJsonFactory;

@SdkProtectedApi
public final class AwsCborProtocolFactory
extends BaseAwsJsonProtocolFactory {
    private static final JsonContentTypeResolver AWS_CBOR = new DefaultJsonContentTypeResolver("application/x-amz-cbor-");

    private AwsCborProtocolFactory(Builder builder) {
        super((BaseAwsJsonProtocolFactory.Builder)builder);
    }

    protected JsonContentTypeResolver getContentTypeResolver() {
        if (this.isCborEnabled()) {
            return AWS_CBOR;
        }
        return AWS_JSON;
    }

    protected StructuredJsonFactory getSdkFactory() {
        if (this.isCborEnabled()) {
            return AwsStructuredCborFactory.SDK_CBOR_FACTORY;
        }
        return super.getSdkFactory();
    }

    protected Map<MarshallLocation, TimestampFormatTrait.Format> getDefaultTimestampFormats() {
        if (!this.isCborEnabled()) {
            return super.getDefaultTimestampFormats();
        }
        EnumMap<MarshallLocation, TimestampFormatTrait.Format> formats = new EnumMap<MarshallLocation, TimestampFormatTrait.Format>(MarshallLocation.class);
        formats.put(MarshallLocation.HEADER, TimestampFormatTrait.Format.RFC_822);
        formats.put(MarshallLocation.PAYLOAD, TimestampFormatTrait.Format.UNIX_TIMESTAMP_MILLIS);
        return Collections.unmodifiableMap(formats);
    }

    private boolean isCborEnabled() {
        return SdkSystemSetting.CBOR_ENABLED.getBooleanValueOrThrow();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends BaseAwsJsonProtocolFactory.Builder<Builder> {
        private Builder() {
        }

        public AwsCborProtocolFactory build() {
            return new AwsCborProtocolFactory(this);
        }
    }
}

