/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ScalingMetricType {
    ASG_AVERAGE_CPU_UTILIZATION("ASGAverageCPUUtilization"),
    ASG_AVERAGE_NETWORK_IN("ASGAverageNetworkIn"),
    ASG_AVERAGE_NETWORK_OUT("ASGAverageNetworkOut"),
    DYNAMO_DB_READ_CAPACITY_UTILIZATION("DynamoDBReadCapacityUtilization"),
    DYNAMO_DB_WRITE_CAPACITY_UTILIZATION("DynamoDBWriteCapacityUtilization"),
    ECS_SERVICE_AVERAGE_CPU_UTILIZATION("ECSServiceAverageCPUUtilization"),
    ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION("ECSServiceAverageMemoryUtilization"),
    ALB_REQUEST_COUNT_PER_TARGET("ALBRequestCountPerTarget"),
    RDS_READER_AVERAGE_CPU_UTILIZATION("RDSReaderAverageCPUUtilization"),
    RDS_READER_AVERAGE_DATABASE_CONNECTIONS("RDSReaderAverageDatabaseConnections"),
    EC2_SPOT_FLEET_REQUEST_AVERAGE_CPU_UTILIZATION("EC2SpotFleetRequestAverageCPUUtilization"),
    EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_IN("EC2SpotFleetRequestAverageNetworkIn"),
    EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_OUT("EC2SpotFleetRequestAverageNetworkOut"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ScalingMetricType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScalingMetricType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ScalingMetricType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScalingMetricType> knownValues() {
        return Stream.of(ScalingMetricType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

