/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ServiceNamespace {
    AUTOSCALING("autoscaling"),
    ECS("ecs"),
    EC2("ec2"),
    RDS("rds"),
    DYNAMODB("dynamodb"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ServiceNamespace(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceNamespace fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ServiceNamespace.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceNamespace> knownValues() {
        return Stream.of(ServiceNamespace.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

