/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscalingplans.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a predefined metric that can be used for dynamic scaling as part of a target tracking scaling policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredefinedScalingMetricSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<PredefinedScalingMetricSpecification.Builder, PredefinedScalingMetricSpecification> {
    private static final SdkField<String> PREDEFINED_SCALING_METRIC_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PredefinedScalingMetricType")
            .getter(getter(PredefinedScalingMetricSpecification::predefinedScalingMetricTypeAsString))
            .setter(setter(Builder::predefinedScalingMetricType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedScalingMetricType")
                    .build()).build();

    private static final SdkField<String> RESOURCE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceLabel").getter(getter(PredefinedScalingMetricSpecification::resourceLabel))
            .setter(setter(Builder::resourceLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLabel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PREDEFINED_SCALING_METRIC_TYPE_FIELD, RESOURCE_LABEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String predefinedScalingMetricType;

    private final String resourceLabel;

    private PredefinedScalingMetricSpecification(BuilderImpl builder) {
        this.predefinedScalingMetricType = builder.predefinedScalingMetricType;
        this.resourceLabel = builder.resourceLabel;
    }

    /**
     * <p>
     * The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Auto Scaling groups, Spot
     * Fleet requests, and ECS services.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #predefinedScalingMetricType} will return {@link ScalingMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #predefinedScalingMetricTypeAsString}.
     * </p>
     * 
     * @return The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Auto Scaling
     *         groups, Spot Fleet requests, and ECS services.
     * @see ScalingMetricType
     */
    public final ScalingMetricType predefinedScalingMetricType() {
        return ScalingMetricType.fromValue(predefinedScalingMetricType);
    }

    /**
     * <p>
     * The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Auto Scaling groups, Spot
     * Fleet requests, and ECS services.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #predefinedScalingMetricType} will return {@link ScalingMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #predefinedScalingMetricTypeAsString}.
     * </p>
     * 
     * @return The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Auto Scaling
     *         groups, Spot Fleet requests, and ECS services.
     * @see ScalingMetricType
     */
    public final String predefinedScalingMetricTypeAsString() {
        return predefinedScalingMetricType;
    }

    /**
     * <p>
     * Identifies the resource associated with the metric type. You can't specify a resource label unless the metric
     * type is <code>ALBRequestCountPerTarget</code> and there is a target group for an Application Load Balancer
     * attached to the Auto Scaling group, Spot Fleet request, or ECS service.
     * </p>
     * <p>
     * You create the resource label by appending the final portion of the load balancer ARN and the final portion of
     * the target group ARN into a single value, separated by a forward slash (/). The format is
     * app/&lt;load-balancer-name
     * &gt;/&lt;load-balancer-id&gt;/targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt;, where:
     * </p>
     * <ul>
     * <li>
     * <p>
     * app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt; is the final portion of the load balancer ARN
     * </p>
     * </li>
     * <li>
     * <p>
     * targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt; is the final portion of the target group ARN.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This is an example:
     * app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
     * </p>
     * <p>
     * To find the ARN for an Application Load Balancer, use the <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html"
     * >DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html"
     * >DescribeTargetGroups</a> API operation.
     * </p>
     * 
     * @return Identifies the resource associated with the metric type. You can't specify a resource label unless the
     *         metric type is <code>ALBRequestCountPerTarget</code> and there is a target group for an Application Load
     *         Balancer attached to the Auto Scaling group, Spot Fleet request, or ECS service.</p>
     *         <p>
     *         You create the resource label by appending the final portion of the load balancer ARN and the final
     *         portion of the target group ARN into a single value, separated by a forward slash (/). The format is
     *         app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt;/targetgroup/&lt;target-group-name&gt;/&lt;target-
     *         group-id&gt;, where:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt; is the final portion of the load balancer ARN
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt; is the final portion of the target group
     *         ARN.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This is an example:
     *         app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
     *         </p>
     *         <p>
     *         To find the ARN for an Application Load Balancer, use the <a href=
     *         "https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html"
     *         >DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href=
     *         "https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html"
     *         >DescribeTargetGroups</a> API operation.
     */
    public final String resourceLabel() {
        return resourceLabel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(predefinedScalingMetricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceLabel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredefinedScalingMetricSpecification)) {
            return false;
        }
        PredefinedScalingMetricSpecification other = (PredefinedScalingMetricSpecification) obj;
        return Objects.equals(predefinedScalingMetricTypeAsString(), other.predefinedScalingMetricTypeAsString())
                && Objects.equals(resourceLabel(), other.resourceLabel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredefinedScalingMetricSpecification")
                .add("PredefinedScalingMetricType", predefinedScalingMetricTypeAsString()).add("ResourceLabel", resourceLabel())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredefinedScalingMetricType":
            return Optional.ofNullable(clazz.cast(predefinedScalingMetricTypeAsString()));
        case "ResourceLabel":
            return Optional.ofNullable(clazz.cast(resourceLabel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredefinedScalingMetricSpecification, T> g) {
        return obj -> g.apply((PredefinedScalingMetricSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredefinedScalingMetricSpecification> {
        /**
         * <p>
         * The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Auto Scaling groups,
         * Spot Fleet requests, and ECS services.
         * </p>
         * 
         * @param predefinedScalingMetricType
         *        The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Auto Scaling
         *        groups, Spot Fleet requests, and ECS services.
         * @see ScalingMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingMetricType
         */
        Builder predefinedScalingMetricType(String predefinedScalingMetricType);

        /**
         * <p>
         * The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Auto Scaling groups,
         * Spot Fleet requests, and ECS services.
         * </p>
         * 
         * @param predefinedScalingMetricType
         *        The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Auto Scaling
         *        groups, Spot Fleet requests, and ECS services.
         * @see ScalingMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingMetricType
         */
        Builder predefinedScalingMetricType(ScalingMetricType predefinedScalingMetricType);

        /**
         * <p>
         * Identifies the resource associated with the metric type. You can't specify a resource label unless the metric
         * type is <code>ALBRequestCountPerTarget</code> and there is a target group for an Application Load Balancer
         * attached to the Auto Scaling group, Spot Fleet request, or ECS service.
         * </p>
         * <p>
         * You create the resource label by appending the final portion of the load balancer ARN and the final portion
         * of the target group ARN into a single value, separated by a forward slash (/). The format is
         * app/&lt;load-balancer
         * -name&gt;/&lt;load-balancer-id&gt;/targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt;, where:
         * </p>
         * <ul>
         * <li>
         * <p>
         * app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt; is the final portion of the load balancer ARN
         * </p>
         * </li>
         * <li>
         * <p>
         * targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt; is the final portion of the target group ARN.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This is an example:
         * app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
         * </p>
         * <p>
         * To find the ARN for an Application Load Balancer, use the <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html"
         * >DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html"
         * >DescribeTargetGroups</a> API operation.
         * </p>
         * 
         * @param resourceLabel
         *        Identifies the resource associated with the metric type. You can't specify a resource label unless the
         *        metric type is <code>ALBRequestCountPerTarget</code> and there is a target group for an Application
         *        Load Balancer attached to the Auto Scaling group, Spot Fleet request, or ECS service.</p>
         *        <p>
         *        You create the resource label by appending the final portion of the load balancer ARN and the final
         *        portion of the target group ARN into a single value, separated by a forward slash (/). The format is
         *        app
         *        /&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt;/targetgroup/&lt;target-group-name&gt;/&lt;target
         *        -group-id&gt;, where:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt; is the final portion of the load balancer ARN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt; is the final portion of the target group
         *        ARN.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This is an example:
         *        app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
         *        </p>
         *        <p>
         *        To find the ARN for an Application Load Balancer, use the <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html"
         *        >DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html"
         *        >DescribeTargetGroups</a> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceLabel(String resourceLabel);
    }

    static final class BuilderImpl implements Builder {
        private String predefinedScalingMetricType;

        private String resourceLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(PredefinedScalingMetricSpecification model) {
            predefinedScalingMetricType(model.predefinedScalingMetricType);
            resourceLabel(model.resourceLabel);
        }

        public final String getPredefinedScalingMetricType() {
            return predefinedScalingMetricType;
        }

        public final void setPredefinedScalingMetricType(String predefinedScalingMetricType) {
            this.predefinedScalingMetricType = predefinedScalingMetricType;
        }

        @Override
        public final Builder predefinedScalingMetricType(String predefinedScalingMetricType) {
            this.predefinedScalingMetricType = predefinedScalingMetricType;
            return this;
        }

        @Override
        public final Builder predefinedScalingMetricType(ScalingMetricType predefinedScalingMetricType) {
            this.predefinedScalingMetricType(predefinedScalingMetricType == null ? null : predefinedScalingMetricType.toString());
            return this;
        }

        public final String getResourceLabel() {
            return resourceLabel;
        }

        public final void setResourceLabel(String resourceLabel) {
            this.resourceLabel = resourceLabel;
        }

        @Override
        public final Builder resourceLabel(String resourceLabel) {
            this.resourceLabel = resourceLabel;
            return this;
        }

        @Override
        public PredefinedScalingMetricSpecification build() {
            return new PredefinedScalingMetricSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
